/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import com.beust.jcommander.Parameters;
import info.ata4.unity.asset.bundle.AssetBundle;
import info.ata4.unity.cli.cmd.AssetCommand;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Parameters(commandNames={"bundle-list"}, commandDescription="List files contained in asset bundles.")
public class BundleListCmd
extends AssetCommand {
    private final PrintStream ps;

    public BundleListCmd(PrintStream ps) {
        this.ps = ps;
        this.setProcessAssets(false);
        this.setProcessBundledAssets(false);
    }

    @Override
    public void processAssetBundle(AssetBundle bundle) throws IOException {
        int p1 = 64;
        int p2 = 10;
        this.ps.print(StringUtils.rightPad("Path", p1));
        this.ps.print(" | ");
        this.ps.print(StringUtils.leftPad("Size", p2));
        this.ps.println();
        this.ps.print(StringUtils.repeat("-", p1));
        this.ps.print(" | ");
        this.ps.print(StringUtils.repeat("-", p2));
        this.ps.println();
        for (Map.Entry<String, ByteBuffer> entry : bundle.getEntries().entrySet()) {
            this.ps.print(StringUtils.rightPad(entry.getKey(), p1));
            this.ps.print(" | ");
            this.ps.print(StringUtils.leftPad(String.valueOf(entry.getValue().limit()), p2));
            this.ps.println();
        }
    }
}

