/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import com.beust.jcommander.Parameters;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.cli.cmd.AssetCommand;
import info.ata4.unity.cli.dump.AssetDumper;
import java.io.IOException;

@Parameters(commandNames={"dump"}, commandDescription="Dumps object data to console.")
public class DumpCmd
extends AssetCommand {
    private boolean dumpStructs = false;
    private boolean dumpToFiles = false;

    public boolean isDumpStructs() {
        return this.dumpStructs;
    }

    public DumpCmd setDumpStructs(boolean structs) {
        this.dumpStructs = structs;
        return this;
    }

    public boolean isDumpToFiles() {
        return this.dumpToFiles;
    }

    public DumpCmd setDumpToFiles(boolean dumpToFiles) {
        this.dumpToFiles = dumpToFiles;
        return this;
    }

    @Override
    public void processAsset(AssetFile asset) throws IOException {
        AssetDumper dmp = new AssetDumper(asset);
        dmp.setClassFilter(this.getOptions().getClassFilter());
        if (this.dumpToFiles) {
            dmp.setOutputDir(this.getOutputDir());
        }
        if (this.dumpStructs) {
            dmp.dumpStruct();
        } else {
            dmp.dumpData();
        }
    }
}

