/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import com.beust.jcommander.Parameters;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.asset.bundle.AssetBundle;
import info.ata4.unity.asset.struct.AssetHeader;
import info.ata4.unity.asset.struct.AssetRef;
import info.ata4.unity.asset.struct.ObjectPath;
import info.ata4.unity.asset.struct.TypeTree;
import info.ata4.unity.cli.cmd.AssetCommand;
import info.ata4.util.string.StringUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;

@Parameters(commandNames={"info"}, commandDescription="Shows basic information about assets and asset bundles.")
public class InfoCmd
extends AssetCommand {
    private final PrintStream ps;

    public InfoCmd(PrintStream ps) {
        this.ps = ps;
    }

    @Override
    public void processAsset(AssetFile asset) throws IOException {
        List<ObjectPath> paths = asset.getPaths();
        List<AssetRef> refTable = asset.getReferences();
        AssetHeader header = asset.getHeader();
        TypeTree typeTree = asset.getTypeTree();
        this.ps.println("Header");
        this.ps.println("  File size: " + StringUtils.humanReadableByteCount(header.getFileSize(), true));
        this.ps.println("  Tree size: " + StringUtils.humanReadableByteCount(header.getTreeSize(), true));
        this.ps.println("  Format: " + header.getFormat());
        this.ps.println("  Data offset: " + header.getDataOffset());
        this.ps.println();
        this.ps.println("Serialized data");
        this.ps.println("  Revision: " + typeTree.getEngineVersion());
        this.ps.println("  Version: " + typeTree.getVersion());
        this.ps.println("  Type tree: " + BooleanUtils.toStringYesNo(!typeTree.getFields().isEmpty()));
        this.ps.println("  Objects: " + paths.size());
        this.ps.println();
        if (!refTable.isEmpty()) {
            this.ps.println("External references");
            for (AssetRef ref : refTable) {
                if (!ref.getAssetPath().isEmpty()) {
                    this.ps.printf("  Asset path: \"%s\"\n", ref.getAssetPath());
                }
                if (!ref.getFilePath().isEmpty()) {
                    this.ps.printf("  File path: \"%s\"\n", ref.getFilePath());
                }
                this.ps.printf("  GUID: %s\n", ref.getGUID());
                this.ps.printf("  Type: %d\n", ref.getType());
                this.ps.println();
            }
        }
    }

    @Override
    public void processAssetBundle(AssetBundle bundle) throws IOException {
        this.ps.println("Format: " + bundle.getFormat());
        this.ps.println("Player version: " + bundle.getPlayerVersion());
        this.ps.println("Engine version: " + bundle.getEngineVersion());
        this.ps.println("Compressed: " + BooleanUtils.toStringYesNo(bundle.isCompressed()));
        this.ps.println("Entries: " + bundle.getEntries().size());
        this.ps.println();
    }
}

