/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.cmd;

import com.beust.jcommander.Parameters;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.asset.struct.ObjectPath;
import info.ata4.unity.cli.cmd.AssetCommand;
import info.ata4.unity.cli.extract.AssetExtractor;
import info.ata4.unity.util.ClassID;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Parameters(commandNames={"list"}, commandDescription="Lists all objects inside asset files.")
public class ListCmd
extends AssetCommand {
    private final PrintStream ps;

    public ListCmd(PrintStream ps) {
        this.ps = ps;
    }

    @Override
    protected void processAsset(AssetFile asset) throws IOException {
        List<ObjectPath> paths = asset.getPaths();
        int p1 = 12;
        int p2 = 4;
        int p3 = 24;
        int p4 = 10;
        int p5 = 10;
        int p6 = 11;
        this.ps.print(StringUtils.rightPad("PID", p1));
        this.ps.print(" | ");
        this.ps.print(StringUtils.rightPad("CID", p2));
        this.ps.print(" | ");
        this.ps.print(StringUtils.rightPad("Class name", p3));
        this.ps.print(" | ");
        this.ps.print(StringUtils.rightPad("Offset", p4));
        this.ps.print(" | ");
        this.ps.print(StringUtils.leftPad("Size", p5));
        this.ps.print(" | ");
        this.ps.print(StringUtils.rightPad("Object name", p6));
        this.ps.println();
        this.ps.print(StringUtils.repeat("-", p1));
        this.ps.print(" | ");
        this.ps.print(StringUtils.repeat("-", p2));
        this.ps.print(" | ");
        this.ps.print(StringUtils.repeat("-", p3));
        this.ps.print(" | ");
        this.ps.print(StringUtils.repeat("-", p4));
        this.ps.print(" | ");
        this.ps.print(StringUtils.repeat("-", p5));
        this.ps.print(" | ");
        this.ps.print(StringUtils.repeat("-", p6));
        this.ps.println();
        for (ObjectPath path : paths) {
            if (path.isScript()) continue;
            String name = AssetExtractor.getObjectName(asset, path);
            if (name == null) {
                name = "";
            }
            this.ps.print(StringUtils.rightPad(String.valueOf(path.getPathID()), p1));
            this.ps.print(" | ");
            this.ps.print(StringUtils.rightPad(String.valueOf(path.getClassID()), p2));
            this.ps.print(" | ");
            this.ps.print(StringUtils.rightPad(ClassID.getNameForID(path.getClassID(), true), p3));
            this.ps.print(" | ");
            this.ps.print(StringUtils.rightPad(String.format("0x%x", path.getOffset()), p4));
            this.ps.print(" | ");
            this.ps.print(StringUtils.leftPad(String.valueOf(path.getLength()), p5));
            this.ps.print(" | ");
            this.ps.print(name);
            this.ps.println();
        }
    }
}

