/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.extract;

import info.ata4.io.DataOutputWriter;
import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.log.LogUtils;
import info.ata4.unity.asset.struct.ObjectPath;
import info.ata4.unity.cli.extract.AssetExtractHandler;
import info.ata4.unity.engine.Texture2D;
import info.ata4.unity.engine.enums.TextureFormat;
import info.ata4.unity.serdes.UnityObject;
import info.ata4.util.io.image.dds.DDSHeader;
import info.ata4.util.io.image.dds.DDSPixelFormat;
import info.ata4.util.io.image.ktx.KTXHeader;
import info.ata4.util.io.image.tga.TGAHeader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Texture2DHandler
extends AssetExtractHandler {
    private static final Logger L = LogUtils.getLogger();
    private ObjectPath path;
    private Texture2D tex;
    private boolean tgaSaveMipMaps = true;

    public boolean isTargaSaveMipMaps() {
        return this.tgaSaveMipMaps;
    }

    public void setTargaSaveMipMaps(boolean tgaSaveMipMaps) {
        this.tgaSaveMipMaps = tgaSaveMipMaps;
    }

    @Override
    public void extract(UnityObject obj) throws IOException {
        this.path = this.path;
        try {
            this.tex = new Texture2D(obj);
        }
        catch (RuntimeException ex) {
            L.log(Level.WARNING, "Deserialization error", ex);
            return;
        }
        if (this.tex.textureFormat == null) {
            L.log(Level.WARNING, "Texture2D {0}: Unknown texture format {1}", new Object[]{this.tex.name, this.tex.textureFormatOrd});
            return;
        }
        if (this.tex.imageBuffer.capacity() == 0) {
            L.log(Level.WARNING, "Texture2D {0}: Empty image buffer", this.tex.name);
            return;
        }
        switch (this.tex.textureFormat) {
            case Alpha8: 
            case RGB24: 
            case RGBA32: 
            case BGRA32: 
            case ARGB32: 
            case ARGB4444: 
            case RGBA4444: 
            case RGB565: {
                this.extractTGA();
                break;
            }
            case PVRTC_RGB2: 
            case PVRTC_RGBA2: 
            case PVRTC_RGB4: 
            case PVRTC_RGBA4: 
            case ATC_RGB4: 
            case ATC_RGBA8: 
            case ETC_RGB4: 
            case ETC2_RGB4: 
            case ETC2_RGB4_PUNCHTHROUGH_ALPHA: 
            case ETC2_RGBA8: 
            case EAC_R: 
            case EAC_R_SIGNED: 
            case EAC_RG: 
            case EAC_RG_SIGNED: {
                this.extractKTX();
                break;
            }
            case DXT1: 
            case DXT5: {
                this.extractDDS();
                break;
            }
            default: {
                L.log(Level.WARNING, "Texture2D {0}: Unsupported texture format {1}", new Object[]{this.tex.name, this.tex.textureFormat});
            }
        }
    }

    private int getMipMapCount(int width, int height) {
        int mipMapCount = 1;
        for (int dim = Math.max(width, height); dim > 1; dim /= 2) {
            ++mipMapCount;
        }
        return mipMapCount;
    }

    private void extractDDS() throws IOException {
        DDSHeader header = new DDSHeader();
        header.dwWidth = this.tex.width;
        header.dwHeight = this.tex.height;
        switch (this.tex.textureFormat) {
            case Alpha8: {
                header.ddspf.dwFlags = 2;
                header.ddspf.dwABitMask = 255;
                header.ddspf.dwRGBBitCount = 8;
                break;
            }
            case RGB24: {
                header.ddspf.dwFlags = 64;
                header.ddspf.dwRBitMask = 0xFF0000;
                header.ddspf.dwGBitMask = 65280;
                header.ddspf.dwBBitMask = 255;
                header.ddspf.dwRGBBitCount = 24;
                break;
            }
            case RGBA32: {
                header.ddspf.dwFlags = 65;
                header.ddspf.dwRBitMask = 255;
                header.ddspf.dwGBitMask = 65280;
                header.ddspf.dwBBitMask = 0xFF0000;
                header.ddspf.dwABitMask = -16777216;
                header.ddspf.dwRGBBitCount = 32;
                break;
            }
            case BGRA32: {
                header.ddspf.dwFlags = 65;
                header.ddspf.dwRBitMask = 0xFF0000;
                header.ddspf.dwGBitMask = 65280;
                header.ddspf.dwBBitMask = 255;
                header.ddspf.dwABitMask = -16777216;
                header.ddspf.dwRGBBitCount = 32;
                break;
            }
            case ARGB32: {
                header.ddspf.dwFlags = 65;
                header.ddspf.dwRBitMask = 65280;
                header.ddspf.dwGBitMask = 0xFF0000;
                header.ddspf.dwBBitMask = -16777216;
                header.ddspf.dwABitMask = 255;
                header.ddspf.dwRGBBitCount = 32;
                break;
            }
            case ARGB4444: {
                header.ddspf.dwFlags = 65;
                header.ddspf.dwRBitMask = 3840;
                header.ddspf.dwGBitMask = 240;
                header.ddspf.dwBBitMask = 15;
                header.ddspf.dwABitMask = 61440;
                header.ddspf.dwRGBBitCount = 16;
                break;
            }
            case RGBA4444: {
                header.ddspf.dwFlags = 65;
                header.ddspf.dwRBitMask = 61440;
                header.ddspf.dwGBitMask = 3840;
                header.ddspf.dwBBitMask = 240;
                header.ddspf.dwABitMask = 15;
                header.ddspf.dwRGBBitCount = 16;
                break;
            }
            case RGB565: {
                header.ddspf.dwFlags = 64;
                header.ddspf.dwRBitMask = 63488;
                header.ddspf.dwGBitMask = 2016;
                header.ddspf.dwBBitMask = 31;
                header.ddspf.dwRGBBitCount = 16;
                break;
            }
            case DXT1: {
                header.ddspf.dwFourCC = DDSPixelFormat.PF_DXT1;
                break;
            }
            case DXT5: {
                header.ddspf.dwFourCC = DDSPixelFormat.PF_DXT5;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid texture format for DDS: " + (Object)((Object)this.tex.textureFormat));
            }
        }
        if (this.tex.mipMap.booleanValue()) {
            header.dwFlags |= 0x20000;
            header.dwCaps |= 0x400008;
            header.dwMipMapCount = this.getMipMapCount(header.dwWidth, header.dwHeight);
        }
        header.dwFlags |= 0x80000;
        if (header.ddspf.dwFourCC != 0) {
            header.dwPitchOrLinearSize = header.dwWidth * header.dwHeight;
            if (this.tex.textureFormat == TextureFormat.DXT1) {
                header.dwPitchOrLinearSize /= 2;
            }
            header.ddspf.dwFlags |= 4;
        } else {
            header.dwPitchOrLinearSize = this.tex.width * this.tex.height * header.ddspf.dwRGBBitCount / 8;
        }
        ByteBuffer bbTex = ByteBuffer.allocateDirect(128 + this.tex.imageBuffer.capacity());
        bbTex.order(ByteOrder.LITTLE_ENDIAN);
        DataOutputWriter out = DataOutputWriter.newWriter((ByteBuffer)bbTex);
        header.write(out);
        bbTex.put(this.tex.imageBuffer);
        bbTex.rewind();
        this.setOutputFileName(this.tex.name);
        this.setOutputFileExtension("dds");
        this.writeData(bbTex);
    }

    private void extractPKM() throws IOException {
        int texWidth = (this.tex.width - 1 | 3) + 1;
        int texHeight = (this.tex.height - 1 | 3) + 1;
        ByteBuffer res = ByteBuffer.allocateDirect(16 + this.tex.imageBuffer.capacity());
        res.order(ByteOrder.BIG_ENDIAN);
        res.putLong(5785802946947055616L);
        res.putShort((short)texWidth);
        res.putShort((short)texHeight);
        res.putShort(this.tex.width.shortValue());
        res.putShort(this.tex.height.shortValue());
        res.put(this.tex.imageBuffer);
        res.rewind();
        this.setOutputFileName(this.tex.name);
        this.setOutputFileExtension("pkm");
        this.writeData(res);
    }

    private void extractTGA() throws IOException {
        TGAHeader header = new TGAHeader();
        switch (this.tex.textureFormat) {
            case Alpha8: {
                header.imageType = (byte)3;
                header.pixelDepth = (byte)8;
                break;
            }
            case RGBA32: 
            case BGRA32: 
            case ARGB32: 
            case ARGB4444: 
            case RGBA4444: {
                header.imageType = (byte)2;
                header.pixelDepth = (byte)32;
                break;
            }
            case RGB24: 
            case RGB565: {
                header.imageType = (byte)2;
                header.pixelDepth = (byte)24;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid texture format for TGA: " + (Object)((Object)this.tex.textureFormat));
            }
        }
        this.convertToRGBA32();
        ByteBuffer bb = this.tex.imageBuffer;
        int mipMapCount = 1;
        if (this.tex.mipMap.booleanValue()) {
            mipMapCount = this.getMipMapCount(this.tex.width, this.tex.height);
        }
        for (int i = 0; i < this.tex.imageCount; ++i) {
            header.imageWidth = this.tex.width;
            header.imageHeight = this.tex.height;
            for (int j = 0; j < mipMapCount; ++j) {
                int imageSize = header.imageWidth * header.imageHeight * header.pixelDepth / 8;
                if (this.tgaSaveMipMaps || j == 0) {
                    ByteBuffer bbTga = ByteBuffer.allocateDirect(18 + imageSize);
                    bbTga.order(ByteOrder.LITTLE_ENDIAN);
                    DataOutputWriter out = DataOutputWriter.newWriter((ByteBuffer)bbTga);
                    header.write(out);
                    bb.limit(bb.position() + imageSize);
                    bbTga.put(bb);
                    bb.limit(bb.capacity());
                    assert (!bbTga.hasRemaining());
                    bbTga.rewind();
                    String fileName = this.tex.name;
                    if (this.tex.imageCount > 1) {
                        fileName = fileName + "_" + i;
                    }
                    if (this.tex.mipMap.booleanValue() && this.tgaSaveMipMaps) {
                        fileName = fileName + "_mip_" + j;
                    }
                    this.setOutputFileName(fileName);
                    this.setOutputFileExtension("tga");
                    this.writeData(bbTga);
                } else {
                    bb.position(bb.position() + imageSize);
                }
                if (header.imageWidth > 1) {
                    header.imageWidth /= 2;
                }
                if (header.imageHeight <= 1) continue;
                header.imageHeight /= 2;
            }
        }
        assert (!bb.hasRemaining());
    }

    private void convertToRGBA32() {
        ByteBuffer imageBufferNew;
        int i;
        byte[] pixelNew;
        byte[] pixelOld;
        ByteBuffer imageBuffer = this.tex.imageBuffer;
        TextureFormat tf = this.tex.textureFormat;
        if (tf == TextureFormat.RGBA32 || tf == TextureFormat.ARGB32) {
            pixelOld = new byte[4];
            pixelNew = new byte[4];
            for (i = 0; i < imageBuffer.capacity() / 4; ++i) {
                imageBuffer.mark();
                imageBuffer.get(pixelOld);
                if (tf == TextureFormat.ARGB32) {
                    pixelNew[0] = pixelOld[3];
                    pixelNew[1] = pixelOld[2];
                    pixelNew[2] = pixelOld[1];
                    pixelNew[3] = pixelOld[0];
                } else {
                    pixelNew[0] = pixelOld[2];
                    pixelNew[1] = pixelOld[1];
                    pixelNew[2] = pixelOld[0];
                    pixelNew[3] = pixelOld[3];
                }
                imageBuffer.reset();
                imageBuffer.put(pixelNew);
            }
            imageBuffer.rewind();
        }
        if (tf == TextureFormat.RGB24) {
            pixelOld = new byte[3];
            pixelNew = new byte[3];
            for (i = 0; i < imageBuffer.capacity() / 3; ++i) {
                imageBuffer.mark();
                imageBuffer.get(pixelOld);
                pixelNew[0] = pixelOld[2];
                pixelNew[1] = pixelOld[1];
                pixelNew[2] = pixelOld[0];
                imageBuffer.reset();
                imageBuffer.put(pixelNew);
            }
            imageBuffer.rewind();
        } else if (tf == TextureFormat.ARGB4444 || tf == TextureFormat.RGBA4444) {
            int newImageSize = imageBuffer.capacity() * 2;
            imageBufferNew = ByteBuffer.allocateDirect(newImageSize);
            byte[] pixelOld2 = new byte[4];
            byte[] pixelNew2 = new byte[4];
            for (int i2 = 0; i2 < imageBuffer.capacity() / 2; ++i2) {
                short pixelOldShort = imageBuffer.getShort();
                pixelOld2[0] = (byte)((pixelOldShort & 0xF000) >> 12);
                pixelOld2[1] = (byte)((pixelOldShort & 0xF00) >> 8);
                pixelOld2[2] = (byte)((pixelOldShort & 0xF0) >> 4);
                pixelOld2[3] = (byte)(pixelOldShort & 0xF);
                pixelOld2[0] = (byte)(pixelOld2[0] << 4);
                pixelOld2[1] = (byte)(pixelOld2[1] << 4);
                pixelOld2[2] = (byte)(pixelOld2[2] << 4);
                pixelOld2[3] = (byte)(pixelOld2[3] << 4);
                if (tf == TextureFormat.ARGB4444) {
                    pixelNew2[0] = pixelOld2[3];
                    pixelNew2[1] = pixelOld2[2];
                    pixelNew2[2] = pixelOld2[1];
                    pixelNew2[3] = pixelOld2[0];
                } else {
                    pixelNew2[0] = pixelOld2[2];
                    pixelNew2[1] = pixelOld2[1];
                    pixelNew2[2] = pixelOld2[0];
                    pixelNew2[3] = pixelOld2[3];
                }
                imageBufferNew.put(pixelNew2);
            }
            assert (!imageBuffer.hasRemaining());
            assert (!imageBufferNew.hasRemaining());
            imageBufferNew.rewind();
            imageBuffer = imageBufferNew;
        } else if (tf == TextureFormat.RGB565) {
            int newImageSize = imageBuffer.capacity() / 2 * 3;
            imageBufferNew = ByteBuffer.allocateDirect(newImageSize);
            byte[] pixel = new byte[3];
            for (int i3 = 0; i3 < imageBuffer.capacity() / 2; ++i3) {
                short pixelOld3 = imageBuffer.getShort();
                pixel[0] = (byte)((pixelOld3 & 0xF800) >> 11);
                pixel[1] = (byte)((pixelOld3 & 0x7E0) >> 5);
                pixel[2] = (byte)(pixelOld3 & 0x1F);
                pixel[0] = (byte)(pixel[0] * 527 + 23 >> 6);
                pixel[1] = (byte)(pixel[1] * 259 + 33 >> 6);
                pixel[2] = (byte)(pixel[2] * 527 + 23 >> 6);
                imageBufferNew.put(pixel);
            }
            assert (!imageBuffer.hasRemaining());
            assert (!imageBufferNew.hasRemaining());
            imageBufferNew.rewind();
            imageBuffer = imageBufferNew;
        }
        this.tex.imageBuffer = imageBuffer;
    }

    private void extractKTX() throws IOException {
        int bpp;
        KTXHeader header = new KTXHeader();
        header.swap = true;
        header.glTypeSize = 1;
        header.pixelWidth = this.tex.width;
        header.pixelHeight = this.tex.height;
        header.pixelDepth = 0;
        header.numberOfFaces = this.tex.imageCount;
        header.numberOfMipmapLevels = this.tex.mipMap != false ? this.getMipMapCount(header.pixelWidth, header.pixelHeight) : 1;
        switch (this.tex.textureFormat) {
            case PVRTC_RGB2: {
                header.glInternalFormat = 35841;
                header.glBaseInternalFormat = 6407;
                bpp = 2;
                break;
            }
            case PVRTC_RGBA2: {
                header.glInternalFormat = 35843;
                header.glBaseInternalFormat = 6408;
                bpp = 2;
                break;
            }
            case PVRTC_RGB4: {
                header.glInternalFormat = 35840;
                header.glBaseInternalFormat = 6407;
                bpp = 4;
                break;
            }
            case PVRTC_RGBA4: {
                header.glInternalFormat = 35842;
                header.glBaseInternalFormat = 6408;
                bpp = 4;
                break;
            }
            case ATC_RGB4: {
                header.glInternalFormat = 35986;
                header.glBaseInternalFormat = 6407;
                bpp = 4;
                break;
            }
            case ATC_RGBA8: {
                header.glInternalFormat = 35987;
                header.glBaseInternalFormat = 6408;
                bpp = 8;
                break;
            }
            case ETC_RGB4: {
                header.glInternalFormat = 36196;
                header.glBaseInternalFormat = 6407;
                bpp = 4;
                break;
            }
            case ETC2_RGB4: {
                header.glInternalFormat = 37492;
                header.glBaseInternalFormat = 6407;
                bpp = 4;
                break;
            }
            case ETC2_RGB4_PUNCHTHROUGH_ALPHA: {
                header.glInternalFormat = 37494;
                header.glBaseInternalFormat = 6408;
                bpp = 4;
                break;
            }
            case ETC2_RGBA8: {
                header.glInternalFormat = 37496;
                header.glBaseInternalFormat = 6408;
                bpp = 8;
                break;
            }
            case EAC_R: {
                header.glInternalFormat = 37488;
                header.glBaseInternalFormat = 6403;
                bpp = 4;
                break;
            }
            case EAC_R_SIGNED: {
                header.glInternalFormat = 37489;
                header.glBaseInternalFormat = 6403;
                bpp = 4;
                break;
            }
            case EAC_RG: {
                header.glInternalFormat = 37490;
                header.glBaseInternalFormat = 33319;
                bpp = 8;
                break;
            }
            case EAC_RG_SIGNED: {
                header.glInternalFormat = 37491;
                header.glBaseInternalFormat = 33319;
                bpp = 4;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid texture format for KTX: " + (Object)((Object)this.tex.textureFormat));
            }
        }
        int imageSizeTotal = 64 + this.tex.imageBuffer.capacity() + header.numberOfMipmapLevels * 4;
        ByteBuffer bb = ByteBuffer.allocateDirect(imageSizeTotal);
        header.write(DataOutputWriter.newWriter((ByteBuffer)bb));
        int mipMapWidth = header.pixelWidth;
        int mipMapHeight = header.pixelHeight;
        int mipMapOffset = 0;
        for (int i = 0; i < header.numberOfMipmapLevels; ++i) {
            bb.putInt(mipMapWidth);
            int mipMapSize = mipMapWidth * mipMapHeight * bpp / 8;
            ByteBuffer mipMapBuffer = ByteBufferUtils.getSlice((ByteBuffer)this.tex.imageBuffer, (int)mipMapOffset, (int)mipMapSize);
            bb.put(mipMapBuffer);
            mipMapWidth /= 2;
            mipMapHeight /= 2;
            mipMapOffset += mipMapSize;
        }
        bb.rewind();
        this.setOutputFileName(this.tex.name);
        this.setOutputFileExtension("ktx");
        this.writeData(bb);
    }
}

