/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.extract.mesh;

import info.ata4.unity.cli.extract.AssetExtractHandler;
import info.ata4.unity.cli.extract.mesh.MeshData;
import info.ata4.unity.cli.extract.mesh.MeshFormat;
import info.ata4.unity.cli.extract.mesh.MeshWriter;
import info.ata4.unity.cli.extract.mesh.ObjWriter;
import info.ata4.unity.cli.extract.mesh.PlyWriter;
import info.ata4.unity.engine.Mesh;
import info.ata4.unity.serdes.UnityObject;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class MeshHandler
extends AssetExtractHandler {
    private MeshFormat format = MeshFormat.OBJ;

    public MeshFormat getFormat() {
        return this.format;
    }

    public void setFormat(MeshFormat format) {
        this.format = format;
    }

    @Override
    public void extract(UnityObject obj) throws IOException {
        MeshWriter meshWriter;
        MeshData meshData = new MeshData(new Mesh(obj));
        switch (this.format) {
            case PLY: {
                meshWriter = new PlyWriter(this);
                break;
            }
            case OBJ: {
                meshWriter = new ObjWriter(this);
                break;
            }
            default: {
                throw new RuntimeException("Unknown mesh format: " + (Object)((Object)this.format));
            }
        }
        meshWriter.write(meshData);
    }

    PrintStream getPrintStream(String name, String ext) throws IOException {
        this.setOutputFileName(name);
        this.setOutputFileExtension(ext);
        Path file = this.getOutputFile();
        return new PrintStream(new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0])));
    }
}

