/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.extract.mesh;

import info.ata4.unity.DisUnity;
import info.ata4.unity.cli.extract.mesh.MeshData;
import info.ata4.unity.cli.extract.mesh.MeshHandler;
import info.ata4.unity.cli.extract.mesh.MeshWriter;
import info.ata4.unity.engine.Mesh;
import info.ata4.unity.engine.struct.Vector2f;
import info.ata4.unity.engine.struct.Vector3f;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ObjWriter
extends MeshWriter {
    private PrintStream ps;
    private List<Vector2f> vts;
    private List<Vector3f> vns;

    ObjWriter(MeshHandler handler) {
        super(handler);
    }

    @Override
    public void write(MeshData meshData) throws IOException {
        Mesh mesh = meshData.getMesh();
        this.vns = meshData.getNormals();
        this.vts = meshData.getUV1();
        if (this.vts.isEmpty()) {
            this.vts = meshData.getUV2();
        }
        try (PrintStream ps_ = this.handler.getPrintStream(mesh.name, "obj");){
            this.ps = ps_;
            this.writeComment("Created by " + DisUnity.getSignature());
            for (Vector3f v : meshData.getVertices()) {
                this.writeVertex(v);
            }
            for (Vector3f vn : this.vns) {
                this.writeNormal(vn);
            }
            for (Vector2f vt : this.vts) {
                this.writeUV(vt);
            }
            this.writeLine();
            this.writeObject(mesh.name);
            this.writeSmooth(1);
            int subMeshCount = mesh.subMeshes.size();
            int vertsPerFace = 3;
            for (int i = 0; i < subMeshCount; ++i) {
                if (subMeshCount == 1) {
                    this.writeUsemtl(mesh.name);
                } else {
                    this.writeUsemtl(String.format("%s_%d", mesh.name, i));
                }
                List<Integer> subMeshTriangles = meshData.getTriangles().get(i);
                ArrayList<Integer> faceTriangles = new ArrayList<Integer>();
                for (Integer t : subMeshTriangles) {
                    faceTriangles.add(t);
                    if (faceTriangles.size() != 3) continue;
                    this.writeFace(faceTriangles);
                    faceTriangles.clear();
                }
                this.writeLine();
            }
        }
    }

    private void writeLine() {
        this.ps.println();
    }

    private void writeComment(String comment) {
        this.ps.print("# ");
        this.ps.println(comment);
    }

    private void writeObject(String name) {
        this.ps.print("g ");
        this.ps.println(name);
    }

    private void writeSmooth(int smooth) {
        this.ps.print("s ");
        this.ps.println(smooth);
    }

    private void writeUsemtl(String material) {
        this.ps.print("usemtl ");
        this.ps.println(material);
    }

    private void writeFace(List<Integer> indices) {
        this.ps.print("f ");
        Collections.reverse(indices);
        boolean vt = !this.vts.isEmpty();
        boolean vn = !this.vns.isEmpty();
        for (int index : indices) {
            int i = index + 1;
            this.ps.print(i);
            if (vt || vn) {
                this.ps.print('/');
                if (vt) {
                    this.ps.print(i);
                }
                this.ps.print('/');
                if (vn) {
                    this.ps.print(i);
                }
            }
            this.ps.print(' ');
        }
        this.ps.print('\n');
    }

    private void writeVector(String prefix, Vector2f v) {
        this.ps.print(prefix);
        this.ps.print(' ');
        this.ps.print(v.x);
        this.ps.print(' ');
        this.ps.print(1.0f - v.y);
        this.ps.println();
    }

    private void writeVector(String prefix, Vector3f v) {
        this.ps.print(prefix);
        this.ps.print(' ');
        this.ps.print(-v.x);
        this.ps.print(' ');
        this.ps.print(v.y);
        this.ps.print(' ');
        this.ps.print(v.z);
        this.ps.println();
    }

    private void writeVertex(Vector3f v) {
        this.writeVector("v", v);
    }

    private void writeNormal(Vector3f vn) {
        this.writeVector("vn", vn);
    }

    private void writeUV(Vector2f vt) {
        this.writeVector("vt", vt);
    }
}

