/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.cli.extract.mesh;

import info.ata4.unity.DisUnity;
import info.ata4.unity.cli.extract.mesh.MeshData;
import info.ata4.unity.cli.extract.mesh.MeshHandler;
import info.ata4.unity.cli.extract.mesh.MeshWriter;
import info.ata4.unity.engine.Mesh;
import info.ata4.unity.engine.SubMesh;
import info.ata4.unity.engine.struct.Color32;
import info.ata4.unity.engine.struct.Vector2f;
import info.ata4.unity.engine.struct.Vector3f;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class PlyWriter
extends MeshWriter {
    private PrintStream ps;

    PlyWriter(MeshHandler handler) {
        super(handler);
    }

    @Override
    void write(MeshData meshData) throws IOException {
        Mesh mesh = meshData.getMesh();
        List<Vector3f> vertices = meshData.getVertices();
        List<Vector3f> normals = meshData.getNormals();
        List<Vector2f> uv1 = meshData.getUV1();
        List<Vector2f> uv2 = meshData.getUV2();
        List<Color32> colors = meshData.getColors();
        int subMeshCount = mesh.subMeshes.size();
        int vertsPerFace = 3;
        for (int i = 0; i < subMeshCount; ++i) {
            SubMesh subMesh = mesh.subMeshes.get(i);
            String name = mesh.name;
            if (subMeshCount > 1) {
                name = String.format("%s_%d", name, i);
            }
            try (PrintStream ps_ = this.handler.getPrintStream(name, "ply");){
                this.ps = ps_;
                List<Integer> subMeshTriangles = meshData.getTriangles().get(i);
                int firstVertex = subMesh.firstVertex.intValue();
                int vertexCount = subMesh.vertexCount.intValue();
                int faceCount = subMeshTriangles.size() / 3;
                this.writeHeaderStart();
                this.writeComment("Created by " + DisUnity.getSignature());
                this.writeVertexHeader(vertexCount, !normals.isEmpty(), !uv1.isEmpty(), !uv2.isEmpty(), !colors.isEmpty());
                this.writeFaceHeader(faceCount);
                this.writeHeaderEnd();
                for (int j = firstVertex; j < firstVertex + vertexCount; ++j) {
                    Vector3f v = vertices.get(j);
                    Vector3f vn = normals.isEmpty() ? null : normals.get(j);
                    Vector2f vt1 = uv1.isEmpty() ? null : uv1.get(j);
                    Vector2f vt2 = uv2.isEmpty() ? null : uv2.get(j);
                    Color32 c = colors.isEmpty() ? null : colors.get(j);
                    this.writeVertex(v, vn, vt1, vt2, c);
                }
                ArrayList<Integer> faceTriangles = new ArrayList<Integer>();
                for (int j = 0; j < subMeshTriangles.size(); ++j) {
                    faceTriangles.add(subMeshTriangles.get(j) - firstVertex);
                    if (faceTriangles.size() != 3) continue;
                    this.writeFace(faceTriangles);
                    faceTriangles.clear();
                }
                continue;
            }
        }
    }

    private void writeLine() {
        this.ps.println();
    }

    private void writeHeaderStart() {
        this.ps.println("ply");
        this.ps.println("format ascii 1.0");
    }

    private void writeComment(String comment) {
        this.ps.print("comment ");
        this.ps.println(comment);
    }

    private void writeVertexHeader(int elements, boolean normals, boolean uv1, boolean uv2, boolean colors) {
        this.ps.print("element vertex ");
        this.ps.println(elements);
        this.ps.println("property float x");
        this.ps.println("property float y");
        this.ps.println("property float z");
        if (normals) {
            this.ps.println("property float nx");
            this.ps.println("property float ny");
            this.ps.println("property float nz");
        }
        if (uv1) {
            this.ps.println("property float s");
            this.ps.println("property float t");
        }
        if (uv2) {
            this.ps.println("property float s2");
            this.ps.println("property float t2");
        }
        if (colors) {
            this.ps.println("property uchar red");
            this.ps.println("property uchar green");
            this.ps.println("property uchar blue");
        }
    }

    private void writeFaceHeader(int elements) {
        this.ps.print("element face ");
        this.ps.println(elements);
        this.ps.println("property list uchar int vertex_indices");
    }

    private void writeHeaderEnd() {
        this.ps.println("end_header");
    }

    private void writeVector(Vector2f v) {
        this.ps.print(v.x);
        this.ps.print(' ');
        this.ps.print(1.0f - v.y);
    }

    private void writeVector(Vector3f v) {
        this.ps.print(-v.x);
        this.ps.print(' ');
        this.ps.print(-v.z);
        this.ps.print(' ');
        this.ps.print(v.y);
    }

    private void writeColor(Color32 c) {
        this.ps.print(c.r);
        this.ps.print(' ');
        this.ps.print(c.g);
        this.ps.print(' ');
        this.ps.print(c.b);
    }

    private void writeVertex(Vector3f v, Vector3f vn, Vector2f vt1, Vector2f vt2, Color32 c) {
        this.writeVector(v);
        if (vn != null) {
            this.ps.print(' ');
            this.writeVector(vn);
        }
        if (vt1 != null) {
            this.ps.print(' ');
            this.writeVector(vt1);
        }
        if (vt2 != null) {
            this.ps.print(' ');
            this.writeVector(vt2);
        }
        if (c != null) {
            this.ps.print(' ');
            this.writeColor(c);
        }
        this.writeLine();
    }

    private void writeFace(List<Integer> indices) {
        Collections.reverse(indices);
        this.ps.print(indices.size());
        this.ps.print(' ');
        for (Integer index : indices) {
            this.ps.print(index);
            this.ps.print(' ');
        }
        this.ps.println();
    }
}

