/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.engine;

import info.ata4.unity.engine.ChannelInfo;
import info.ata4.unity.engine.StreamInfo;
import info.ata4.unity.serdes.UnityObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class VertexData {
    public final Long currentChannels;
    public final Long vertexCount;
    public final List<ChannelInfo> channels;
    public final List<StreamInfo> streams;
    public final ByteBuffer dataSize;

    public VertexData(UnityObject obj) {
        this.currentChannels = (Long)obj.getValue("m_CurrentChannels");
        this.vertexCount = (Long)obj.getValue("m_VertexCount");
        List channelObjects = (List)obj.getValue("m_Channels");
        this.channels = new ArrayList<ChannelInfo>();
        if (channelObjects != null) {
            for (UnityObject channelObject : channelObjects) {
                this.channels.add(new ChannelInfo(channelObject));
            }
        }
        List streamObjects = (List)obj.getValue("m_Streams");
        this.streams = new ArrayList<StreamInfo>();
        if (streamObjects != null) {
            for (UnityObject streamObject : streamObjects) {
                this.streams.add(new StreamInfo(streamObject));
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                StreamInfo streamInfo = obj.getObject("m_Streams[" + i + "]", StreamInfo.class);
                if (streamInfo == null) continue;
                this.streams.add(streamInfo);
            }
        }
        this.dataSize = (ByteBuffer)obj.getValue("m_DataSize");
    }
}

