/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.serdes;

import info.ata4.log.LogUtils;
import info.ata4.unity.serdes.UnityTag;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnityObject
implements UnityTag<Map<String, UnityTag>> {
    private static final Logger L = LogUtils.getLogger();
    private String name;
    private String type;
    private Map<String, UnityTag> fields = new LinkedHashMap<String, UnityTag>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public Map<String, UnityTag> get() {
        return this.fields;
    }

    @Override
    public void set(Map<String, UnityTag> value) {
        this.fields = value;
    }

    public <T> T getValue(String name, boolean unwrap) {
        UnityTag f = this.fields.get(name);
        if (f == null) {
            return null;
        }
        if (unwrap) {
            while (f.get() instanceof UnityTag) {
                f = (UnityTag)f.get();
            }
        }
        return f.get();
    }

    public <T> T getValue(String name) {
        return this.getValue(name, true);
    }

    public <T> void setValue(String name, T value, boolean unwrap) {
        UnityTag f = this.fields.get(name);
        if (f == null) {
            return;
        }
        if (unwrap) {
            while (f.get() instanceof UnityTag) {
                f = (UnityTag)f.get();
            }
        }
        f.set(value);
    }

    public <T> void setValue(String name, T value) {
        this.setValue(name, value, true);
    }

    public <T> T getObject(String name, Class<T> clazz) {
        if (!this.hasValue(name)) {
            return null;
        }
        UnityObject obj = (UnityObject)this.getValue(name, false);
        try {
            Constructor<T> cnst = clazz.getConstructor(UnityObject.class);
            return cnst.newInstance(obj);
        }
        catch (ReflectiveOperationException ex) {
            L.log(Level.SEVERE, "Can't instantiate object from class " + clazz.getName(), ex);
            return null;
        }
    }

    public boolean hasValue(String name) {
        return this.fields.containsKey(name);
    }
}

