/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.serdes.db;

import info.ata4.log.LogUtils;
import info.ata4.unity.asset.struct.TypeField;
import info.ata4.unity.util.UnityVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class FieldTypeMap
extends HashMap<Pair<Integer, UnityVersion>, TypeField> {
    private static final Logger L = LogUtils.getLogger();

    public TypeField get(int classID, UnityVersion revision) {
        return this.get(classID, revision, true);
    }

    public TypeField get(int classID, UnityVersion version, boolean strict) {
        TypeField fieldNode = (TypeField)this.get(new ImmutablePair<Integer, UnityVersion>(classID, version));
        if (fieldNode != null || strict) {
            return fieldNode;
        }
        TypeField fieldNodeB = null;
        UnityVersion versionB = null;
        TypeField fieldNodeC = null;
        UnityVersion versionC = null;
        for (Map.Entry entry : this.entrySet()) {
            Pair fieldNodeKey = (Pair)entry.getKey();
            if ((Integer)fieldNodeKey.getLeft() != classID) continue;
            TypeField fieldNodeEntry = (TypeField)entry.getValue();
            UnityVersion revisionEntry = (UnityVersion)fieldNodeKey.getRight();
            if (revisionEntry.getMajor() == version.getMajor()) {
                if (revisionEntry.getMinor() == version.getMinor()) {
                    return fieldNodeEntry;
                }
                fieldNodeB = fieldNodeEntry;
                versionB = revisionEntry;
            }
            fieldNodeC = fieldNodeEntry;
            versionC = revisionEntry;
        }
        if (fieldNodeB != null) {
            L.log(Level.WARNING, "Unprecise match for ClassID {0} (required: {1}, available: {2})", new Object[]{classID, version, versionB});
            return fieldNodeB;
        }
        if (fieldNodeC != null) {
            L.log(Level.WARNING, "Bad match for ClassID {0} (required: {1}, available: {2})", new Object[]{classID, version, versionC});
            return fieldNodeC;
        }
        return null;
    }

    public void add(int classID, UnityVersion revision, TypeField fieldNode) {
        this.put(new ImmutablePair<Integer, UnityVersion>(classID, revision), fieldNode);
    }
}

