/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.serdes.db;

import info.ata4.io.DataInputReader;
import info.ata4.io.DataOutputWriter;
import info.ata4.log.LogUtils;
import info.ata4.unity.asset.AssetFile;
import info.ata4.unity.asset.struct.TypeField;
import info.ata4.unity.asset.struct.TypeTree;
import info.ata4.unity.serdes.db.FieldTypeMap;
import info.ata4.unity.util.ClassID;
import info.ata4.unity.util.UnityVersion;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;

public class StructDatabase {
    private static final Logger L = LogUtils.getLogger();
    private static final int VERSION = 1;
    private static final String FILENAME = "structdb.dat";
    private static StructDatabase instance;
    private FieldTypeMap ftm = new FieldTypeMap();
    private int learned;

    public static StructDatabase getInstance() {
        if (instance == null) {
            instance = new StructDatabase();
        }
        return instance;
    }

    private StructDatabase() {
        this.load();
    }

    public int getLearned() {
        return this.learned;
    }

    public FieldTypeMap getFieldTypeMap() {
        return this.ftm;
    }

    private void load() {
        InputStream is;
        L.info("Loading struct database");
        try {
            Path dbFile = Paths.get(FILENAME, new String[0]);
            String dbPath = "/resources/structdb.dat";
            is = Files.exists(dbFile, new LinkOption[0]) ? Files.newInputStream(dbFile, new OpenOption[0]) : this.getClass().getResourceAsStream(dbPath);
            if (is == null) {
                throw new IOException("Struct database file not found");
            }
        }
        catch (Exception ex) {
            L.log(Level.SEVERE, "Can't open struct database", ex);
            return;
        }
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            DataInputReader in = DataInputReader.newReader((InputStream)bis);
            int dbVersion = in.readInt();
            if (dbVersion != 1) {
                throw new RuntimeException("Wrong database version");
            }
            int fieldNodeSize = in.readInt();
            ArrayList<TypeField> fieldNodes = new ArrayList<TypeField>(fieldNodeSize);
            for (int i = 0; i < fieldNodeSize; ++i) {
                TypeField fieldNode = new TypeField();
                fieldNode.read(in);
                fieldNodes.add(fieldNode);
            }
            int versionSize = in.readInt();
            ArrayList<UnityVersion> versions = new ArrayList<UnityVersion>(versionSize);
            for (int i = 0; i < versionSize; ++i) {
                versions.add(new UnityVersion(in.readStringNull()));
            }
            int fieldNodeKeySize = in.readInt();
            for (int i = 0; i < fieldNodeKeySize; ++i) {
                int index = in.readInt();
                int classID = in.readInt();
                int revisionIndex = in.readInt();
                UnityVersion version = (UnityVersion)versions.get(revisionIndex);
                TypeField fieldNode = (TypeField)fieldNodes.get(index);
                this.ftm.add(classID, version, fieldNode);
            }
        }
        catch (IOException ex) {
            L.log(Level.SEVERE, "Can't read struct database", ex);
        }
    }

    private void save() {
        L.info("Saving struct database");
        File dbFile = new File(FILENAME);
        try (BufferedOutputStream bos = new BufferedOutputStream(FileUtils.openOutputStream(dbFile));){
            DataOutputWriter out = DataOutputWriter.newWriter((OutputStream)bos);
            out.writeInt(1);
            HashSet fieldNodes = new HashSet(this.ftm.values());
            HashMap<TypeField, Integer> fieldNodeMap = new HashMap<TypeField, Integer>();
            out.writeInt(fieldNodes.size());
            int index = 0;
            for (TypeField fieldNode : fieldNodes) {
                fieldNodeMap.put(fieldNode, index++);
                fieldNode.write(out);
            }
            HashSet versions = new HashSet();
            HashMap<UnityVersion, Integer> versionMap = new HashMap<UnityVersion, Integer>();
            for (Map.Entry entry : this.ftm.entrySet()) {
                versions.add(((Pair)entry.getKey()).getRight());
            }
            out.writeInt(versions.size());
            index = 0;
            for (UnityVersion version : versions) {
                versionMap.put(version, index++);
                out.writeStringNull(version.toString());
            }
            out.writeInt(this.ftm.entrySet().size());
            for (Map.Entry entry : this.ftm.entrySet()) {
                index = (Integer)fieldNodeMap.get(entry.getValue());
                Pair fieldNodeKey = (Pair)entry.getKey();
                int classID = (Integer)fieldNodeKey.getLeft();
                UnityVersion version = (UnityVersion)fieldNodeKey.getRight();
                out.writeInt(index);
                out.writeInt(classID);
                out.writeInt(((Integer)versionMap.get(version)).intValue());
            }
        }
        catch (IOException ex) {
            L.log(Level.SEVERE, "Can't write struct database", ex);
        }
    }

    public void fill(AssetFile asset) {
        TypeTree typeTree = asset.getTypeTree();
        Set<Integer> classIDs = asset.getClassIDs();
        this.fixRevision(asset, typeTree);
        if (typeTree.getEngineVersion() == null) {
            L.warning("Revision = null");
            return;
        }
        for (Integer classID : classIDs) {
            TypeField ft = this.ftm.get(classID, typeTree.getEngineVersion(), false);
            if (ft == null) continue;
            typeTree.getFields().put(classID, ft);
        }
    }

    public int learn(AssetFile asset) {
        TypeTree typeTree = asset.getTypeTree();
        Set<Integer> classIDs = asset.getClassIDs();
        if (typeTree.getFields().isEmpty()) {
            L.info("No type tree available");
            return 0;
        }
        this.fixRevision(asset, typeTree);
        if (typeTree.getEngineVersion() == null) {
            L.warning("Revision = null");
            return 0;
        }
        int learnedNew = 0;
        for (Integer classID : classIDs) {
            int hash2;
            int hash1;
            TypeField fieldType = typeTree.getFields().get(classID);
            String fieldClassName = ClassID.getNameForID(classID);
            if (fieldType == null) continue;
            TypeField fieldTypeMapped = this.ftm.get(classID, typeTree.getEngineVersion());
            if (fieldTypeMapped == null) {
                fieldTypeMapped = fieldType;
                L.log(Level.INFO, "New: {0} ({1})", new Object[]{classID, fieldClassName});
                this.ftm.add(classID, typeTree.getEngineVersion(), fieldTypeMapped);
                ++learnedNew;
            }
            if ((hash1 = fieldType.hashCode()) != (hash2 = fieldTypeMapped.hashCode())) {
                L.log(Level.WARNING, "Database hash mismatch for {0}: {1} != {2}", new Object[]{fieldTypeMapped.getType(), hash1, hash2});
            }
            if (fieldClassName != null) continue;
            L.log(Level.WARNING, "Unknown ClassID {0}, suggested name: {1}", new Object[]{classID, fieldType.getType()});
        }
        this.learned += learnedNew;
        return learnedNew;
    }

    public void update() {
        if (this.learned > 0) {
            L.log(Level.INFO, "Adding {0} new struct(s) to database", this.learned);
            this.save();
            this.learned = 0;
        }
    }

    private void fixRevision(AssetFile asset, TypeTree typeTree) {
        if (typeTree.getEngineVersion() == null && asset.getSourceBundle() != null) {
            typeTree.setEngineVersion(asset.getSourceBundle().getEngineVersion());
        }
    }
}

