/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.unity.util;

import info.ata4.log.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class ClassID {
    private static final Logger L = LogUtils.getLogger();
    private static final String CLASSID_PATH = "/resources/classid.txt";
    private static final String CHARSET = "ASCII";
    private static final Map<Integer, String> ID_TO_NAME;
    private static final Map<String, Integer> NAME_TO_ID;

    public static Integer getIDForName(String className, boolean ignoreCase) {
        if (ignoreCase) {
            for (Map.Entry<String, Integer> entry : NAME_TO_ID.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(className)) continue;
                return entry.getValue();
            }
            return null;
        }
        return NAME_TO_ID.get(className);
    }

    public static Integer getIDForName(String className) {
        return ClassID.getIDForName(className, false);
    }

    public static String getNameForID(int classID, boolean safe) {
        String className = ID_TO_NAME.get(classID);
        if (className == null && safe) {
            className = "Class" + classID;
        }
        return className;
    }

    public static String getNameForID(int classID) {
        return ClassID.getNameForID(classID, false);
    }

    private ClassID() {
    }

    static {
        HashMap<Integer, String> IDToName = new HashMap<Integer, String>();
        HashMap<String, Integer> nameToID = new HashMap<String, Integer>();
        try (InputStream is = ClassID.class.getResourceAsStream(CLASSID_PATH);){
            if (is == null) {
                throw new IOException("Class ID database not found");
            }
            List<String> lines = IOUtils.readLines(is, CHARSET);
            for (String line : lines) {
                String[] parts;
                if (line.startsWith("#") || line.startsWith("//") || line.trim().isEmpty() || (parts = line.split("\\W+")).length != 2) continue;
                int id = Integer.parseInt(parts[0]);
                String name = parts[1];
                IDToName.put(id, name);
                nameToID.put(name, id);
            }
        }
        catch (Exception ex) {
            L.log(Level.WARNING, "Can't load class ID database", ex);
        }
        ID_TO_NAME = Collections.unmodifiableMap(IDToName);
        NAME_TO_ID = Collections.unmodifiableMap(nameToID);
    }
}

