/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.util.io.image.dds;

import info.ata4.io.DataInputReader;
import info.ata4.io.DataOutputWriter;
import info.ata4.io.Struct;
import info.ata4.util.io.image.dds.DDSPixelFormat;
import info.ata4.util.string.StringUtils;
import java.io.IOException;

public class DDSHeader
implements Struct {
    public static final int DDS_MAGIC = StringUtils.makeID("DDS ");
    public static final int DDS_STRUCT_SIZE = 124;
    public static final int SIZE = 128;
    public static final int DDS_FOURCC = 4;
    public static final int DDS_RGB = 64;
    public static final int DDS_RGBA = 65;
    public static final int DDS_LUMINANCE = 131072;
    public static final int DDS_LUMINANCEA = 131073;
    public static final int DDS_ALPHA = 2;
    public static final int DDS_PAL8 = 32;
    public static final int DDS_HEADER_FLAGS_TEXTURE = 4103;
    public static final int DDS_HEADER_FLAGS_MIPMAP = 131072;
    public static final int DDS_HEADER_FLAGS_VOLUME = 0x800000;
    public static final int DDS_HEADER_FLAGS_PITCH = 8;
    public static final int DDS_HEADER_FLAGS_LINEARSIZE = 524288;
    public static final int DDS_HEIGHT = 2;
    public static final int DDS_WIDTH = 4;
    public static final int DDS_SURFACE_FLAGS_TEXTURE = 4096;
    public static final int DDS_SURFACE_FLAGS_MIPMAP = 0x400008;
    public static final int DDS_SURFACE_FLAGS_CUBEMAP = 8;
    public static final int DDS_CUBEMAP_POSITIVEX = 1536;
    public static final int DDS_CUBEMAP_NEGATIVEX = 2560;
    public static final int DDS_CUBEMAP_POSITIVEY = 4608;
    public static final int DDS_CUBEMAP_NEGATIVEY = 8704;
    public static final int DDS_CUBEMAP_POSITIVEZ = 16896;
    public static final int DDS_CUBEMAP_NEGATIVEZ = 33280;
    public static final int DDS_CUBEMAP_ALLFACES = 65024;
    public static final int DDS_CUBEMAP = 512;
    public static final int DDS_FLAGS_VOLUME = 0x200000;
    public int dwMagic = DDS_MAGIC;
    public int dwSize = 124;
    public int dwFlags = 4103;
    public int dwHeight;
    public int dwWidth;
    public int dwPitchOrLinearSize;
    public int dwDepth;
    public int dwMipMapCount;
    public int[] dwReserved1 = new int[11];
    public DDSPixelFormat ddspf = new DDSPixelFormat();
    public int dwCaps = 4096;
    public int dwCaps2;
    public int dwCaps3;
    public int dwCaps4;
    public int dwReserved2;

    public void read(DataInputReader in) throws IOException {
        this.dwMagic = in.readInt();
        this.dwSize = in.readInt();
        this.dwFlags = in.readInt();
        this.dwHeight = in.readInt();
        this.dwWidth = in.readInt();
        this.dwPitchOrLinearSize = in.readInt();
        this.dwDepth = in.readInt();
        this.dwMipMapCount = in.readInt();
        for (int i = 0; i < this.dwReserved1.length; ++i) {
            this.dwReserved1[i] = in.readInt();
        }
        this.ddspf.read(in);
        this.dwCaps = in.readInt();
        this.dwCaps2 = in.readInt();
        this.dwCaps3 = in.readInt();
        this.dwCaps4 = in.readInt();
        this.dwReserved2 = in.readInt();
    }

    public void write(DataOutputWriter out) throws IOException {
        out.writeInt(this.dwMagic);
        out.writeInt(this.dwSize);
        out.writeInt(this.dwFlags);
        out.writeInt(this.dwHeight);
        out.writeInt(this.dwWidth);
        out.writeInt(this.dwPitchOrLinearSize);
        out.writeInt(this.dwDepth);
        out.writeInt(this.dwMipMapCount);
        for (int i = 0; i < this.dwReserved1.length; ++i) {
            out.writeInt(this.dwReserved1[i]);
        }
        this.ddspf.write(out);
        out.writeInt(this.dwCaps);
        out.writeInt(this.dwCaps2);
        out.writeInt(this.dwCaps3);
        out.writeInt(this.dwCaps4);
        out.writeInt(this.dwReserved2);
    }
}

