/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.encrypted;

import org.catacombae.dmgextractor.Util;
import org.catacombae.io.ReadableRandomAccessStream;

class CEncryptedEncodingUtil {
    private static final String V1_SIGNATURE = "cdsaencr";
    private static final String V2_SIGNATURE = "encrcdsa";

    CEncryptedEncodingUtil() {
    }

    public static int detectVersion(ReadableRandomAccessStream stream) {
        byte[] signatureBytes = new byte[8];
        try {
            stream.seek(0L);
            stream.readFully(signatureBytes);
            if (Util.toASCIIString(signatureBytes).equals(V2_SIGNATURE)) {
                return 2;
            }
        }
        catch (Exception e) {
            System.err.println("Non-critical exception while detecting version 2 CEncryptedEncoding header:");
            e.printStackTrace();
        }
        try {
            stream.seek(stream.length() - (long)signatureBytes.length);
            stream.readFully(signatureBytes);
            if (Util.toASCIIString(signatureBytes).equals(V1_SIGNATURE)) {
                return 1;
            }
        }
        catch (Exception e) {
            System.err.println("Non-critical exception while detecting version 1 CEncryptedEncoding header:");
            e.printStackTrace();
        }
        return -1;
    }
}

