/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.encrypted;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.catacombae.dmg.encrypted.Debug;
import org.catacombae.dmg.encrypted.V1Header;
import org.catacombae.dmg.encrypted.V2Header;
import org.catacombae.dmgextractor.Util;

public abstract class CommonCEncryptedEncodingHeader {
    public static CommonCEncryptedEncodingHeader create(V1Header header) {
        return new V1Implementation(header);
    }

    public static CommonCEncryptedEncodingHeader create(V2Header header) {
        return new V2Implementation(header);
    }

    public abstract int getBlockSize();

    public abstract long getBlockDataStart();

    public abstract byte[] getKdfSalt();

    public abstract int getKdfIterationCount();

    public abstract byte[] getUnwrapInitializationVector();

    public abstract long getTrailingReservedBytes();

    public abstract long getEncryptedDataLength();

    public abstract KeySet unwrapKeys(Key var1, Cipher var2) throws GeneralSecurityException, InvalidKeyException, InvalidAlgorithmParameterException;

    private static class V2Implementation
    extends CommonCEncryptedEncodingHeader {
        private final V2Header header;

        public V2Implementation(V2Header header) {
            this.header = header;
        }

        public int getBlockSize() {
            return this.header.getBlockSize();
        }

        public long getBlockDataStart() {
            return this.header.getOffsetToDataStart();
        }

        public long getTrailingReservedBytes() {
            return 0L;
        }

        public byte[] getKdfSalt() {
            return Util.createCopy(this.header.getKdfSalt(), 0, this.header.getKdfSaltLen());
        }

        public int getKdfIterationCount() {
            return this.header.getKdfIterationCount();
        }

        public byte[] getUnwrapInitializationVector() {
            return Util.createCopy(this.header.getBlobEncIv(), 0, this.header.getBlobEncIvSize());
        }

        private byte[] getEncryptedKeyBlob() {
            return Util.createCopy(this.header.getEncryptedKeyblob(), 0, this.header.getEncryptedKeyblobSize());
        }

        public long getEncryptedDataLength() {
            return this.header.getEncryptedDataLength();
        }

        public KeySet unwrapKeys(Key derivedKey, Cipher cph) throws InvalidKeyException, InvalidAlgorithmParameterException, GeneralSecurityException {
            Debug.print("V2Implementation.unwrapKeys(" + derivedKey + ", " + cph + ");");
            cph.init(2, derivedKey, new IvParameterSpec(this.getUnwrapInitializationVector()));
            byte[] encryptedKeyBlob = this.getEncryptedKeyBlob();
            Debug.print("  encryptedKeyBlob.length=" + encryptedKeyBlob.length);
            byte[] decryptedKeyBlob = new byte[encryptedKeyBlob.length];
            Debug.print("  doing update....");
            int bp = cph.update(encryptedKeyBlob, 0, encryptedKeyBlob.length, decryptedKeyBlob);
            Debug.print("    bp == " + bp);
            Debug.print("  doing final....");
            bp += cph.doFinal(decryptedKeyBlob, bp);
            Debug.print("    bp == " + bp);
            Debug.print("  decryptedKeyBlob: 0x" + Util.byteArrayToHexString(decryptedKeyBlob));
            byte[] aesKey = new byte[16];
            byte[] hmacSha1Key = new byte[20];
            System.arraycopy(decryptedKeyBlob, 0, aesKey, 0, 16);
            Debug.print("  aesKey: 0x" + Util.byteArrayToHexString(aesKey));
            System.arraycopy(decryptedKeyBlob, 16, hmacSha1Key, 0, 20);
            Debug.print("  hmacSha1Key: 0x" + Util.byteArrayToHexString(hmacSha1Key));
            Util.zero(new byte[][]{decryptedKeyBlob});
            Debug.print("  decryptedKeyBlob: 0x" + Util.byteArrayToHexString(decryptedKeyBlob));
            Debug.print("returning from V2Implementation.unwrapKeys...");
            return new KeySet(aesKey, hmacSha1Key);
        }
    }

    private static class V1Implementation
    extends CommonCEncryptedEncodingHeader {
        private final V1Header header;

        public V1Implementation(V1Header header) {
            this.header = header;
        }

        public int getBlockSize() {
            return this.header.getBlockSize();
        }

        public long getBlockDataStart() {
            return 0L;
        }

        public long getTrailingReservedBytes() {
            V1Implementation v1Implementation = this;
            return v1Implementation.header.length();
        }

        public byte[] getKdfSalt() {
            return Util.createCopy(this.header.getKdfSalt(), 0, this.header.getKdfSaltLen());
        }

        public int getKdfIterationCount() {
            return this.header.getKdfIterationCount();
        }

        public byte[] getUnwrapInitializationVector() {
            return this.header.getUnwrapIv();
        }

        public long getEncryptedDataLength() {
            return this.header.getDecryptedDataLength();
        }

        public KeySet unwrapKeys(Key derivedKey, Cipher cph) throws GeneralSecurityException, InvalidKeyException, InvalidAlgorithmParameterException {
            byte[] aesKey = this.unwrapIndividualKey(derivedKey, cph, Util.createCopy(this.header.getWrappedAesKey(), 0, this.header.getLenWrappedAesKey()));
            byte[] hmacSha1Key = this.unwrapIndividualKey(derivedKey, cph, Util.createCopy(this.header.getWrappedHmacSha1Key(), 0, this.header.getLenWrappedHmacSha1Key()));
            return new KeySet(aesKey, hmacSha1Key);
        }

        public byte[] unwrapIndividualKey(Key key, Cipher cph, byte[] wrappedKey) throws InvalidKeyException, InvalidAlgorithmParameterException, GeneralSecurityException {
            Debug.print("unwrapIndividualKey(" + key + ", " + cph + ", byte[" + wrappedKey.length + "]);");
            Debug.print("  wrappedKey: 0x" + Util.byteArrayToHexString(wrappedKey));
            byte[] initialIv = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
            byte[] ir1 = new byte[wrappedKey.length];
            cph.init(2, key, new IvParameterSpec(initialIv));
            int ir1Len = cph.doFinal(wrappedKey, 0, wrappedKey.length, ir1, 0);
            Debug.print("  ir1: 0x" + Util.byteArrayToHexString(ir1, 0, ir1Len));
            Debug.print("  ir1Len: " + ir1Len);
            byte[] ir2 = new byte[ir1Len];
            for (int i = 0; i < ir1Len; ++i) {
                ir2[i] = ir1[ir1Len - 1 - i];
            }
            Debug.print("  ir2: 0x" + Util.byteArrayToHexString(ir2));
            Debug.print("  ir2.length: " + ir2.length);
            byte[] ir3 = new byte[ir2.length - 8];
            cph.init(2, key, new IvParameterSpec(ir2, 0, 8));
            int ir3Len = cph.doFinal(ir2, 8, ir2.length - 8, ir3, 0);
            Debug.print("  ir3: 0x" + Util.byteArrayToHexString(ir3, 0, ir3Len));
            Debug.print("  ir3Len: " + ir3Len);
            byte[] result = Util.createCopy(ir3, 4, ir3Len - 4);
            Util.zero(ir1, ir2, ir3);
            return result;
        }
    }

    public static class KeySet {
        private final byte[] aesKey;
        private final byte[] hmacSha1Key;

        private KeySet(byte[] aesKey, byte[] hmacSha1Key) {
            this.aesKey = aesKey;
            this.hmacSha1Key = hmacSha1Key;
        }

        public byte[] getAesKey() {
            return this.aesKey;
        }

        public byte[] getHmacSha1Key() {
            return this.hmacSha1Key;
        }

        public void clearData() {
            Util.zero(new byte[][]{this.aesKey});
            Util.zero(new byte[][]{this.hmacSha1Key});
        }
    }
}

