/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmg.encrypted;

import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.catacombae.dmg.encrypted.Assert;
import org.catacombae.dmg.encrypted.CEncryptedEncodingUtil;
import org.catacombae.dmg.encrypted.CommonCEncryptedEncodingHeader;
import org.catacombae.dmg.encrypted.Debug;
import org.catacombae.dmg.encrypted.V1Header;
import org.catacombae.dmg.encrypted.V2Header;
import org.catacombae.dmgextractor.Util;
import org.catacombae.io.BasicReadableRandomAccessStream;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;

public class ReadableCEncryptedEncodingStream
extends BasicReadableRandomAccessStream {
    private final ReadableRandomAccessStream backingStream;
    private final CommonCEncryptedEncodingHeader header;
    private final SecretKeySpec aesKey;
    private final SecretKeySpec hmacSha1Key;
    private final Mac hmacSha1;
    private final Cipher aesCipher;
    private final long streamLength;
    private long blockNumber = 0L;
    private int posInBlock = 0;

    public ReadableCEncryptedEncodingStream(ReadableRandomAccessStream backingStream, char[] password) throws RuntimeIOException {
        Debug.print("ReadableCEncryptedEncodingStream(" + backingStream + ", " + password + ");");
        this.backingStream = backingStream;
        int headerVersion = CEncryptedEncodingUtil.detectVersion(backingStream);
        Debug.print("  headerVersion = " + headerVersion);
        switch (headerVersion) {
            case 1: {
                byte[] v1HeaderData = new byte[V1Header.length()];
                backingStream.seek(backingStream.length() - (long)V1Header.length());
                backingStream.readFully(v1HeaderData);
                V1Header v1header = new V1Header(v1HeaderData, 0);
                Debug.print("  V1 header:");
                v1header.print(Debug.ps, "    ");
                this.header = CommonCEncryptedEncodingHeader.create(v1header);
                break;
            }
            case 2: {
                byte[] v2HeaderData = new byte[V2Header.length()];
                backingStream.seek(0L);
                backingStream.readFully(v2HeaderData);
                V2Header v2header = new V2Header(v2HeaderData, 0);
                Debug.print("  V2 header:");
                v2header.print(Debug.ps, "    ");
                this.header = CommonCEncryptedEncodingHeader.create(v2header);
                break;
            }
            case -1: {
                throw new RuntimeException("No CEncryptedEncoding header found!");
            }
            default: {
                throw new RuntimeException("Unknown header version: " + headerVersion);
            }
        }
        this.streamLength = this.header.getEncryptedDataLength();
        try {
            String pbeAlgorithmName = "PBKDF2WithHmacSHA1";
            PBEKeySpec ks = new PBEKeySpec(password, this.header.getKdfSalt(), this.header.getKdfIterationCount(), 192);
            SecretKeyFactory fact = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKey k = fact.generateSecret(ks);
            byte[] keyData = k.getEncoded();
            Debug.print("Derived key: 0x" + Util.byteArrayToHexString(keyData));
            String cipherAlgorithmName = "DESede/CBC/PKCS5Padding";
            Cipher keyDecryptionCipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            SecretKeyFactory fact2 = SecretKeyFactory.getInstance("DESede");
            SecretKey k2 = fact2.generateSecret(new DESedeKeySpec(keyData));
            CommonCEncryptedEncodingHeader.KeySet keys = this.header.unwrapKeys(k2, keyDecryptionCipher);
            Debug.print("AES key: 0x" + Util.byteArrayToHexString(keys.getAesKey()));
            Debug.print("HmacSHA1 key: 0x" + Util.byteArrayToHexString(keys.getHmacSha1Key()));
            this.aesKey = new SecretKeySpec(keys.getAesKey(), "AES");
            this.hmacSha1Key = new SecretKeySpec(keys.getHmacSha1Key(), "HmacSHA1");
            keys.clearData();
            this.hmacSha1 = Mac.getInstance("HmacSHA1");
            this.hmacSha1.init(this.hmacSha1Key);
            this.aesCipher = Cipher.getInstance("AES/CBC/NoPadding");
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while trying to decrypt keys.", e);
        }
    }

    public static boolean isCEncryptedEncoding(ReadableRandomAccessStream stream) {
        int version = CEncryptedEncodingUtil.detectVersion(stream);
        return version == 1 || version == 2;
    }

    public void close() throws RuntimeIOException {
        this.backingStream.close();
    }

    public void seek(long pos) throws RuntimeIOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Negative seek request: pos (" + pos + ") < 0");
        }
        if (pos > this.streamLength) {
            this.blockNumber = this.streamLength / (long)this.header.getBlockSize();
            this.posInBlock = 0;
        } else {
            long nextBlockNumber = pos / (long)this.header.getBlockSize();
            int nextPosInBlock = (int)(pos % (long)this.header.getBlockSize());
            this.blockNumber = nextBlockNumber;
            this.posInBlock = nextPosInBlock;
        }
    }

    public long length() throws RuntimeIOException {
        return this.streamLength;
    }

    public long getFilePointer() throws RuntimeIOException {
        return this.blockNumber * (long)this.header.getBlockSize() + (long)this.posInBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws RuntimeIOException {
        int n;
        byte[] decBlockData;
        byte[] encBlockData;
        block10: {
            if (len == 0) {
                return 0;
            }
            if (len < 0) {
                throw new IndexOutOfBoundsException("len (" + len + ") < 0");
            }
            if (off < 0) {
                throw new IndexOutOfBoundsException("off (" + off + ") < 0");
            }
            if (off + len > b.length) {
                throw new IndexOutOfBoundsException("off+len (" + (off + len) + ") > b.length (" + b.length + ")");
            }
            this.backingStream.seek(this.header.getBlockDataStart() + this.blockNumber * (long)this.header.getBlockSize());
            encBlockData = new byte[this.header.getBlockSize()];
            decBlockData = new byte[encBlockData.length];
            try {
                int totalBytesRead;
                int bytesToCopy;
                for (totalBytesRead = 0; totalBytesRead < len && this.blockNumber * (long)this.header.getBlockSize() < this.streamLength; totalBytesRead += bytesToCopy) {
                    int bytesRead = this.backingStream.read(encBlockData);
                    if (bytesRead != encBlockData.length) {
                        if (bytesRead <= 0) break;
                        System.err.println("WARNING: Could not read entire block! blockNumber=" + this.blockNumber + ", bytesRead=" + bytesRead);
                        break;
                    }
                    int bytesDecrypted = this.decrypt(encBlockData, decBlockData, this.blockNumber);
                    Assert.eq(bytesDecrypted, decBlockData.length);
                    long bytesLeftInStream = this.streamLength - this.blockNumber * (long)this.header.getBlockSize();
                    int blockSize = (int)(bytesLeftInStream < (long)decBlockData.length ? bytesLeftInStream : (long)decBlockData.length);
                    int bytesLeftToRead = len - totalBytesRead;
                    int bytesLeftInBlock = blockSize - this.posInBlock;
                    bytesToCopy = bytesLeftToRead < bytesLeftInBlock ? bytesLeftToRead : bytesLeftInBlock;
                    System.arraycopy(decBlockData, this.posInBlock, b, off + totalBytesRead, bytesToCopy);
                    if (bytesToCopy == bytesLeftInBlock) {
                        ++this.blockNumber;
                        this.posInBlock = 0;
                        continue;
                    }
                    this.posInBlock += bytesLeftToRead;
                }
                if (totalBytesRead <= 0) break block10;
                n = totalBytesRead;
            }
            catch (Throwable throwable) {
                Util.zero(new byte[][]{encBlockData});
                Util.zero(new byte[][]{decBlockData});
                throw throwable;
            }
            Util.zero(new byte[][]{encBlockData});
            Util.zero(new byte[][]{decBlockData});
            return n;
        }
        n = -1;
        Util.zero(new byte[][]{encBlockData});
        Util.zero(new byte[][]{decBlockData});
        return n;
    }

    private int decrypt(byte[] encBlockData, byte[] decBlockData, long blockNumber) {
        int n;
        Debug.print("decrypt(byte[" + encBlockData.length + "], byte[" + decBlockData.length + "], " + blockNumber + ");");
        if (blockNumber < 0L || blockNumber > Integer.MAX_VALUE) {
            throw new RuntimeException("Block number out of range: " + blockNumber);
        }
        int blockNumberInt = (int)(blockNumber & 0xFFFFFFFFFFFFFFFFL);
        this.hmacSha1.reset();
        this.hmacSha1.update(Util.toByteArrayBE(blockNumberInt));
        byte[] iv = new byte[16];
        System.arraycopy(this.hmacSha1.doFinal(), 0, iv, 0, iv.length);
        try {
            int bytesDecrypted;
            this.aesCipher.init(2, (Key)this.aesKey, new IvParameterSpec(iv));
            n = bytesDecrypted = this.aesCipher.doFinal(encBlockData, 0, encBlockData.length, decBlockData, 0);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Unexpected exception when trying to decrypt block " + blockNumber + ".", e);
            }
            catch (Throwable throwable) {
                Util.zero(new byte[][]{iv});
                throw throwable;
            }
        }
        Util.zero(new byte[][]{iv});
        return n;
    }

    private static void printHelp() {
        System.err.println("usage: " + ReadableCEncryptedEncodingStream.class.getName() + " -i in-file -p password -o out-file");
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        String inputFilename = null;
        String outputFilename = null;
        String password = null;
        for (int i = 0; i < args.length; ++i) {
            String curArg = args[i];
            if (curArg.startsWith("-i")) {
                if (i + 1 < args.length) {
                    inputFilename = args[i + 1];
                    continue;
                }
                ReadableCEncryptedEncodingStream.printHelp();
                continue;
            }
            if (curArg.startsWith("-p")) {
                if (i + 1 < args.length) {
                    password = args[i + 1];
                    continue;
                }
                ReadableCEncryptedEncodingStream.printHelp();
                continue;
            }
            if (!curArg.startsWith("-o")) continue;
            if (i + 1 < args.length) {
                outputFilename = args[i + 1];
                continue;
            }
            ReadableCEncryptedEncodingStream.printHelp();
        }
        if (inputFilename == null || outputFilename == null || password == null) {
            ReadableCEncryptedEncodingStream.printHelp();
        }
        ReadableCEncryptedEncodingStream.runTest(inputFilename, outputFilename, password);
    }

    private static void runTest(String inputFilename, String outputFilename, String password) throws IOException {
        ReadableFileStream backingStream = new ReadableFileStream(inputFilename);
        ReadableCEncryptedEncodingStream rras = new ReadableCEncryptedEncodingStream(backingStream, password.toCharArray());
        System.out.println("Length of encrypted data: " + rras.length() + " bytes");
        byte[] lastBlock = new byte[4096];
        rras.seek(rras.length() - 4096L);
        rras.readFully(lastBlock);
        System.out.println("Last block: 0x" + Util.byteArrayToHexString(lastBlock));
        byte[] sig = new byte[2];
        rras.seek(0L);
        rras.readFully(sig);
        System.out.println("Signature: " + Util.toASCIIString(sig));
        System.out.println("fp=" + rras.getFilePointer());
        byte[] following = new byte[3];
        rras.readFully(following);
        System.out.println("Following(" + following.length + "): 0x" + Util.byteArrayToHexString(following));
        System.out.println("fp=" + rras.getFilePointer());
        rras.readFully(following);
        System.out.println("Following(" + following.length + "): 0x" + Util.byteArrayToHexString(following));
        System.out.println("fp=" + rras.getFilePointer());
        rras.readFully(following);
        System.out.println("Following(" + following.length + "): 0x" + Util.byteArrayToHexString(following));
        System.out.println("fp=" + rras.getFilePointer());
        rras.seek(33792L);
        rras.readFully(sig);
        System.out.println("Signature: " + Util.toASCIIString(sig));
        System.out.println("fp=" + rras.getFilePointer());
        System.out.println("Checking boundary passage:");
        byte[] boundaryBytes = new byte[9];
        rras.seek(36859L);
        rras.readFully(boundaryBytes);
        System.out.println("boundaryBytes(" + boundaryBytes.length + "): 0x" + Util.byteArrayToHexString(boundaryBytes));
        System.out.println("fp=" + rras.getFilePointer());
        System.out.println("Checking reading until eof:");
        byte[] buffer = new byte[5001];
        rras.seek(rras.length() - 12288L);
        int bytesRead = rras.read(buffer);
        long totBytesRead = 0L;
        while (bytesRead != -1) {
            System.out.println("Read " + bytesRead + " bytes.");
            totBytesRead += (long)bytesRead;
            bytesRead = rras.read(buffer);
        }
        System.out.println("Finished. bytesRead=" + bytesRead + " totBytesRead=" + totBytesRead);
        FileOutputStream out = new FileOutputStream(outputFilename);
        System.out.println("Extracting encrypted data to file: " + outputFilename);
        rras.seek(0L);
        byte[] buffer2 = new byte[9119];
        int bytesRead2 = rras.read(buffer2);
        long totalBytesWritten = 0L;
        while (bytesRead2 > 0) {
            System.out.println("Read " + bytesRead2 + " bytes.");
            out.write(buffer2, 0, bytesRead2);
            totalBytesWritten += (long)bytesRead2;
            bytesRead2 = rras.read(buffer2);
        }
        System.out.println("Wrote " + totalBytesWritten + " bytes.");
        out.close();
    }
}

