/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmgextractor;

import java.io.IOException;
import org.catacombae.dmg.udif.UDIFBlock;
import org.catacombae.dmg.udif.UDIFBlockInputStream;
import org.catacombae.dmgextractor.UserInterface;
import org.catacombae.io.RandomAccessStream;
import org.catacombae.io.ReadableRandomAccessStream;

class DMGBlockHandlers {
    private static byte[] inBuffer = new byte[262144];

    DMGBlockHandlers() {
    }

    static long processBlock(UDIFBlock block, ReadableRandomAccessStream dmgRaf, RandomAccessStream isoRaf, boolean testOnly, UserInterface ui) throws IOException {
        UDIFBlockInputStream is = UDIFBlockInputStream.getStream(dmgRaf, block);
        long res = DMGBlockHandlers.processStream(is, isoRaf, testOnly, ui);
        is.close();
        if (res != block.getOutSize()) {
            System.err.println("WARNING: Could not extract entire block! Extracted " + res + " of " + block.getOutSize() + " bytes");
        }
        return res;
    }

    private static long processStream(UDIFBlockInputStream is, RandomAccessStream isoRaf, boolean testOnly, UserInterface ui) throws IOException {
        long totalBytesRead = 0L;
        int bytesRead = is.read(inBuffer);
        while (bytesRead > 0) {
            totalBytesRead += (long)bytesRead;
            ui.addProgressRaw(bytesRead);
            if (!testOnly) {
                isoRaf.write(inBuffer, 0, bytesRead);
            }
            bytesRead = is.read(inBuffer);
        }
        return totalBytesRead;
    }
}

