/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmgextractor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.catacombae.dmg.encrypted.ReadableCEncryptedEncodingStream;
import org.catacombae.dmg.udif.Debug;
import org.catacombae.dmg.udif.Koly;
import org.catacombae.dmg.udif.Plist;
import org.catacombae.dmg.udif.PlistPartition;
import org.catacombae.dmg.udif.UDIFBlock;
import org.catacombae.dmg.udif.UDIFDetector;
import org.catacombae.dmgextractor.BasicUI;
import org.catacombae.dmgextractor.ConcatenatedIterator;
import org.catacombae.dmgextractor.DMGBlockHandlers;
import org.catacombae.dmgextractor.DmgException;
import org.catacombae.dmgextractor.SwingUI;
import org.catacombae.dmgextractor.TextModeUI;
import org.catacombae.dmgextractor.UserInterface;
import org.catacombae.dmgextractor.Util;
import org.catacombae.io.FileStream;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.TruncatableRandomAccessStream;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMGExtractor {
    public static final String BASE_APP_NAME = "DMGExtractor";
    public static final String VERSION = "0.70";
    public static final String APPNAME = "DMGExtractor 0.70";
    public static final String BUILDSTRING = "(Build #437)";
    public static final String[] COPYRIGHT_MESSAGE = new String[]{"DMGExtractor 0.70 (Build #437)", "Copyright \u00a9 2006-2008 Erik Larsson <erik82@kth.se>", "  based on dmg2iso, Copyright \u00a9 2004 vu1tur <v@vu1tur.eu.org>", "  using the libraries:", "    iHarder Base64 Encoder/Decoder <http://iharder.sf.net>", "      released into the public domain", "    Apache Ant bzip2 library <http://ant.apache.org/>", "      released under The Apache Software License Version 2.0", "", "This program is distributed under the GNU General Public License version 3 or", "later. See <http://www.gnu.org/copyleft/gpl.html> for the details.", ""};

    public static void main(String[] args) throws Exception {
        Session ses = null;
        try {
            ses = DMGExtractor.parseArgs(args);
            if (ses.debug) {
                ses.verbose = true;
            }
            BasicUI ui = ses.graphical ? new SwingUI(ses.verbose) : new TextModeUI(ses.verbose);
            ui.displayMessage(COPYRIGHT_MESSAGE);
            if (ses.parseArgsErrorMessage == null) {
                if (ses.graphical) {
                    if (ses.dmgFile == null) {
                        ses.dmgFile = ui.getInputFileFromUser();
                    }
                    if (ses.dmgFile != null && ses.isoFile == null && ui.getOutputConfirmationFromUser()) {
                        ses.isoFile = ui.getOutputFileFromUser(ses.dmgFile);
                        if (ses.isoFile == null) {
                            System.exit(0);
                        }
                    }
                }
                if (ses.dmgFile != null) {
                    String dmgFilename = null;
                    String isoFilename = null;
                    if (ses.dmgFile != null) {
                        dmgFilename = ses.dmgFile.getName();
                    }
                    if (ses.isoFile != null) {
                        isoFilename = ses.isoFile.getName();
                    }
                    ui.setProgressFilenames(dmgFilename, isoFilename);
                    DMGExtractor.extractProcedure(ses, ui);
                } else if (!ses.graphical) {
                    DMGExtractor.printUsageInstructions(ui, ses.startupCommand, "Error: No input file specified.");
                }
            } else {
                DMGExtractor.printUsageInstructions(ui, ses.startupCommand, ses.parseArgsErrorMessage);
            }
        }
        catch (Exception e) {
            if (ses != null && ses.graphical) {
                String stackTrace = e.toString() + "\n";
                for (StackTraceElement ste : e.getStackTrace()) {
                    stackTrace = stackTrace + "    " + ste.toString() + "\n";
                }
                JOptionPane.showMessageDialog(null, "The program encountered an uncaught exception:\n" + stackTrace + "\nCan not recover. Exiting...", "Error", 0);
            }
            throw e;
        }
    }

    private static void extractProcedure(Session ses, UserInterface ui) throws Exception {
        boolean testOnly;
        boolean encrypted;
        ReadableRandomAccessStream dmgRaf;
        block65: {
            ui.displayMessageVerbose("Processing: \"" + ses.dmgFile + "\"");
            dmgRaf = new ReadableFileStream(new RandomAccessFile(ses.dmgFile, "r"));
            if (ReadableCEncryptedEncodingStream.isCEncryptedEncoding(dmgRaf)) {
                encrypted = true;
                while (true) {
                    char[] password;
                    if ((password = ui.getPasswordFromUser()) == null) {
                        ui.displayMessage("No password specified. Can not continue...");
                        System.exit(0);
                    }
                    try {
                        ReadableCEncryptedEncodingStream encryptionFilter = new ReadableCEncryptedEncodingStream(dmgRaf, password);
                        dmgRaf = encryptionFilter;
                        break block65;
                    }
                    catch (Exception e) {
                        ui.displayMessage("Incorrect password!");
                        continue;
                    }
                    break;
                }
            }
            encrypted = false;
        }
        FileStream isoRaf = null;
        if (ses.isoFile != null) {
            testOnly = false;
            isoRaf = new FileStream(ses.isoFile);
            isoRaf.setLength(0L);
            ui.displayMessageVerbose("Extracting to: \"" + ses.isoFile + "\"");
        } else {
            testOnly = true;
            ui.displayMessageVerbose("Simulating extraction...");
        }
        if (!UDIFDetector.isUDIFEncoded(dmgRaf)) {
            if (!encrypted && !ui.warning("The image you selected does not seem to be UDIF encoded or encrypted.", "Its contents will be copied unchanged to the destination.")) {
                System.exit(1);
            }
            DMGExtractor.copyData(dmgRaf, isoRaf, ui);
            System.exit(0);
        }
        dmgRaf.seek(dmgRaf.length() - (long)Koly.length());
        byte[] kolyData = new byte[512];
        int kolyDataRead = dmgRaf.read(kolyData);
        if (kolyDataRead != kolyData.length) {
            throw new RuntimeException("Could not read koly completely. Read " + kolyDataRead + "/" + kolyData.length + " bytes.");
        }
        Koly koly = new Koly(kolyData, 0);
        if (ses.debug) {
            ui.displayMessage("plist addresses:", "  " + koly.getPlistBegin1(), "  " + koly.getPlistBegin2());
        }
        if (koly.getPlistBegin1() != koly.getPlistBegin2()) {
            ui.displayMessage("WARNING: Addresses not equal! Assumption false.", koly.getPlistBegin1() + " != " + koly.getPlistBegin2());
        }
        ui.displayMessageVerbose("Jumping to address...");
        dmgRaf.seek(koly.getPlistBegin1());
        long plistSize = koly.getPlistSize();
        if (plistSize > Integer.MAX_VALUE) {
            throw new RuntimeException("getPlistSize() way too large (" + plistSize + ")!");
        }
        if (plistSize < 0L) {
            throw new RuntimeException("getPlistSize() way too small (" + plistSize + ")!");
        }
        byte[] buffer = new byte[(int)koly.getPlistSize()];
        dmgRaf.read(buffer);
        Plist plist = new Plist(buffer, ses.useSaxParser);
        PlistPartition[] partitions = plist.getPartitions();
        long totalOutSize = 0L;
        for (PlistPartition p : partitions) {
            Iterator<UDIFBlock> blockIt = p.getBlockIterator();
            while (blockIt.hasNext()) {
                totalOutSize += blockIt.next().getOutSize();
            }
        }
        ui.displayMessageVerbose("Target size: " + totalOutSize + " bytes");
        ui.setTotalProgressLength(totalOutSize);
        byte[] zeroblock = new byte[4096];
        Util.zero(new byte[][]{zeroblock});
        int partitionNumber = 0;
        int errorsReported = 0;
        int warningsReported = 0;
        long totalSize = 0L;
        ui.reportProgress(0);
        for (PlistPartition dpp : partitions) {
            long partitionSize = dpp.getPartitionSize();
            totalSize += partitionSize;
            ui.displayMessageVerbose("  " + dpp.getName(), "    ID: " + dpp.getID(), "    Attributes: " + dpp.getAttributes(), "    Partition map block count: " + dpp.getBlockCount(), "    Partition size: " + partitionSize + " bytes");
            int blockCount = 0;
            Iterator<UDIFBlock> blockIterator = dpp.getBlockIterator();
            while (blockIterator.hasNext()) {
                String[] appended;
                if (ui.cancelSignaled()) {
                    System.exit(0);
                }
                UDIFBlock currentBlock = blockIterator.next();
                int blockType = currentBlock.getBlockType();
                long inOffset = currentBlock.getTrueInOffset();
                long inSize = currentBlock.getInSize();
                long outOffset = currentBlock.getTrueOutOffset();
                long outSize = currentBlock.getOutSize();
                long trueOutOffset = currentBlock.getTrueOutOffset();
                long trueInOffset = currentBlock.getTrueInOffset();
                String blockTypeString = currentBlock.getBlockTypeAsString();
                if (ses.debug) {
                    ui.displayMessage("      " + partitionNumber + ":" + blockCount + ". " + blockTypeString + " processing...", "        outOffset=" + outOffset + " outSize=" + outSize, "        inOffset=" + inOffset + " inSize=" + inSize, "        trueOutOffset=" + trueOutOffset + " trueInOffset=" + trueInOffset);
                } else {
                    ui.displayMessageVerbose("      Processing " + blockTypeString + " block. In: " + inSize + " bytes. Out: " + outSize + " bytes.");
                }
                if (!testOnly && isoRaf.getFilePointer() != trueOutOffset) {
                    ++warningsReported;
                    boolean proceed = ui.warning(blockTypeString + " FP != trueOutOffset (" + isoRaf.getFilePointer() + " != " + trueOutOffset + ")");
                    if (!proceed) {
                        System.exit(0);
                    }
                }
                if (blockType == -2147483644) {
                    ++errorsReported;
                    if (DMGExtractor.extractionError(ui, testOnly, "BT_ADC not supported.")) break;
                    System.exit(0);
                } else if (blockType == -2147483643) {
                    try {
                        DMGBlockHandlers.processBlock(currentBlock, dmgRaf, isoRaf, testOnly, ui);
                    }
                    catch (DmgException de) {
                        de.printStackTrace();
                        String[] message = new String[]{"BT_ZLIB Could not decode..."};
                        ++errorsReported;
                        if (!ses.debug) {
                            String[] appended2 = new String[]{"outOffset=" + outOffset + " outSize=" + outSize, "inOffset=" + inOffset + " inSize=" + inSize, "trueOutOffset=" + trueOutOffset + " trueInOffset=" + trueInOffset};
                            message = Util.concatenate(message, appended2);
                        }
                        if (DMGExtractor.extractionError(ui, testOnly, message)) break;
                        System.exit(0);
                    }
                } else if (blockType == -2147483642) {
                    DMGBlockHandlers.processBlock(currentBlock, dmgRaf, isoRaf, testOnly, ui);
                } else if (blockType == 1) {
                    DMGBlockHandlers.processBlock(currentBlock, dmgRaf, isoRaf, testOnly, ui);
                } else if (blockType == 2) {
                    DMGBlockHandlers.processBlock(currentBlock, dmgRaf, isoRaf, testOnly, ui);
                } else if (blockType == 0) {
                    DMGBlockHandlers.processBlock(currentBlock, dmgRaf, isoRaf, testOnly, ui);
                } else if (blockType == 0x7FFFFFFE) {
                    if (inSize != 0L || outSize != 0L) {
                        String[] message = new String[]{"Blocktype BT_UNKNOWN had non-zero sizes...", "  inSize=" + inSize + ", outSize=" + outSize, "  Please contact the author of the program to report this bug!"};
                        ++errorsReported;
                        if (!ses.debug) {
                            appended = new String[]{"outOffset=" + outOffset + " outSize=" + outSize, "inOffset=" + inOffset + " inSize=" + inSize, "trueOutOffset=" + trueOutOffset + " trueInOffset=" + trueInOffset};
                            message = Util.concatenate(message, appended);
                        }
                        if (DMGExtractor.extractionError(ui, testOnly, message)) break;
                        System.exit(0);
                    }
                } else if (blockType != -1) {
                    if (inSize == 0L && outSize == 0L) {
                        ui.warning("previously unseen blocktype " + blockType + " [0x" + Integer.toHexString(blockType) + "]", "outOffset=" + outOffset + " outSize=" + outSize + " inOffset=" + inOffset + " inSize=" + inSize, "As inSize and outSize is 0 (block is a marker?), we can try to continue the operation...");
                        ++warningsReported;
                    } else {
                        String[] message = new String[]{"previously unseen blocktype " + blockType + " [0x" + Integer.toHexString(blockType) + "]", "outOffset=" + outOffset + " outSize=" + outSize + " inOffset=" + inOffset + " inSize=" + inSize, "CRITICAL. inSize and/or outSize are not 0!"};
                        ++errorsReported;
                        if (!ses.debug) {
                            appended = new String[]{"outOffset=" + outOffset + " outSize=" + outSize, "inOffset=" + inOffset + " inSize=" + inSize, "trueOutOffset=" + trueOutOffset + " trueInOffset=" + trueInOffset};
                            message = Util.concatenate(message, appended);
                        }
                        if (DMGExtractor.extractionError(ui, testOnly, message)) break;
                        System.exit(0);
                    }
                }
                ++blockCount;
            }
            ++partitionNumber;
        }
        ui.reportProgress(100);
        ui.reportFinished(isoRaf == null, errorsReported, warningsReported, totalSize);
        if (!ses.debug) {
            if (isoRaf != null) {
                isoRaf.close();
            }
            dmgRaf.close();
        } else {
            if (isoRaf != null) {
                isoRaf.close();
            }
            ConcatenatedIterator<UDIFBlock> cit = new ConcatenatedIterator<UDIFBlock>();
            for (PlistPartition dpp : partitions) {
                cit.add(dpp.getBlockIterator());
            }
            LinkedList<UDIFBlock> blocks = new LinkedList<UDIFBlock>();
            while (cit.hasNext()) {
                UDIFBlock b = (UDIFBlock)cit.next();
                if (b.getInSize() == 0L) continue;
                if (b.getInSize() > 0L) {
                    blocks.add(b);
                    continue;
                }
                throw new RuntimeException("Negative inSize! inSize=" + b.getInSize());
            }
            Collections.sort(blocks);
            LinkedList<UDIFBlock> merged = DMGExtractor.mergeBlocks(blocks.iterator());
            String[] mergedRegions = new String[]{"Merged regions (size: " + merged.size() + "):"};
            for (UDIFBlock b : merged) {
                Util.concatenate(mergedRegions, "  " + b.getTrueInOffset() + " - " + (b.getTrueInOffset() + b.getInSize()));
            }
            Util.concatenate(mergedRegions, "", "Extracting the regions not containing block data from source file...");
            ui.displayMessage(mergedRegions);
            int i = 1;
            Iterator mergedIt = merged.iterator();
            UDIFBlock previous = null;
            if (merged.size() > 0 && merged.getFirst().getTrueInOffset() == 0L) {
                previous = (UDIFBlock)mergedIt.next();
            }
            while (mergedIt.hasNext() || previous != null) {
                UDIFBlock b = null;
                if (mergedIt.hasNext()) {
                    b = (UDIFBlock)mergedIt.next();
                }
                if (b == null || b.getTrueInOffset() > 0L) {
                    int size;
                    long offset;
                    if (previous == null) {
                        offset = 0L;
                        size = (int)b.getInOffset();
                        if (size == 0) {
                            continue;
                        }
                    } else if (b == null) {
                        offset = previous.getTrueInOffset() + previous.getInSize();
                        size = (int)(dmgRaf.length() - offset);
                        if (size == 0) {
                            break;
                        }
                    } else {
                        offset = previous.getTrueInOffset() + previous.getInSize();
                        size = (int)(b.getInOffset() - offset);
                    }
                    String filename = "[" + ses.dmgFile.getName() + "]-" + i++ + "-[" + offset + "-" + (offset + (long)size) + "].region";
                    ui.displayMessage("  " + new File(filename).getCanonicalPath() + " (" + size + " bytes)...");
                    FileOutputStream curFos = new FileOutputStream(new File(filename));
                    if (size < 0) {
                        ui.error("ERROR: Negative array size (" + size + ")...", "  current:", "    " + b.toString(), "  previous:", "    " + previous.toString());
                    }
                    byte[] data = new byte[size];
                    dmgRaf.seek(offset);
                    dmgRaf.read(data);
                    curFos.write(data);
                    curFos.close();
                }
                previous = b;
            }
            dmgRaf.close();
            ui.displayMessage("Done!");
        }
    }

    private static void copyData(ReadableRandomAccessStream inStream, TruncatableRandomAccessStream outStream, UserInterface ui) {
        byte[] buffer = new byte[65536];
        ui.setTotalProgressLength(inStream.length());
        long totalBytesCopied = 0L;
        inStream.seek(0L);
        int bytesRead = inStream.read(buffer);
        while (bytesRead > 0 && !ui.cancelSignaled()) {
            if (outStream != null) {
                outStream.write(buffer, 0, bytesRead);
            }
            ui.addProgressRaw(bytesRead);
            totalBytesCopied += (long)bytesRead;
            bytesRead = inStream.read(buffer);
        }
        ui.reportProgress(100);
        ui.reportFinished(outStream == null, 0, 0, totalBytesCopied);
    }

    private static boolean extractionError(UserInterface ui, boolean testOnly, String ... message) {
        if (!testOnly) {
            ui.error(message);
            return false;
        }
        message = Util.concatenate(message, "The program is run in testing mode, so we can continue...");
        return ui.warning(message);
    }

    private static Session parseArgs(String[] args) {
        Session ses = new Session();
        try {
            String cur;
            int i;
            for (i = 0; i < args.length && (cur = args[i]).startsWith("-"); ++i) {
                if (cur.equals("-gui")) {
                    ses.graphical = true;
                    continue;
                }
                if (cur.equals("-saxparser")) {
                    ses.useSaxParser = true;
                    continue;
                }
                if (cur.equals("-v")) {
                    ses.verbose = true;
                    continue;
                }
                if (cur.equals("-debug")) {
                    Debug.debug = true;
                    ses.debug = true;
                    continue;
                }
                if (cur.equals("-startupcommand")) {
                    ses.startupCommand = args[i + 1];
                    ++i;
                    continue;
                }
                ses.parseArgsErrorMessage = "Invalid argument: " + cur;
                return ses;
            }
            int emptyTrailingEntries = 0;
            for (int j = i; j < args.length; ++j) {
                if (!args[i].equals("")) continue;
                ++emptyTrailingEntries;
            }
            if (i != args.length && args.length - i != emptyTrailingEntries) {
                ses.dmgFile = new File(args[i++]);
                if (ses.dmgFile.exists()) {
                    if (i <= args.length - 1 && !args[i].trim().equals("")) {
                        ses.isoFile = new File(args[i++]);
                    }
                    if (i != args.length && !args[i].trim().equals("")) {
                        ses.parseArgsErrorMessage = "Invalid argument: " + args[i];
                    }
                } else {
                    ses.parseArgsErrorMessage = "Input file \"" + ses.dmgFile + "\" not found!";
                }
            } else if (!ses.graphical) {
                ses.parseArgsErrorMessage = "Error: No input file specified.";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ses.parseArgsErrorMessage = "Unhandled exception: " + e.toString() + " (see console for stacktrace)";
        }
        return ses;
    }

    private static void printUsageInstructions(UserInterface ui, String startupCommand) {
        DMGExtractor.printUsageInstructions(ui, startupCommand, null);
    }

    private static void printUsageInstructions(UserInterface ui, String startupCommand, String errorMessage) {
        String[] prefixMessage = new String[]{};
        if (errorMessage != null) {
            prefixMessage = Util.concatenate(prefixMessage, errorMessage);
        }
        String[] mainMessage = new String[]{"  usage: " + startupCommand + " [options] <dmgFile> [<outputFile>]", "", "  If an output file is not supplied, the program will simulate an extraction", "  (useful for detecting errors in dmg-files).", "", "  options:", "    -v          verbose operation... for finding out what went wrong", "    -saxparser  use the standard SAX parser for XML processing instead of", "                the APX parser (will connect to Apple's website for DTD", "                validation)", "    -gui        starts the program in graphical mode", "    -debug      performs unspecified debug operations (only intended for", "                development use)", ""};
        ui.displayMessage(Util.concatenate(prefixMessage, mainMessage));
    }

    private static void printSAXParserInfo(XMLReader saxParser, PrintStream ps, String prefix) throws Exception {
        ps.println(prefix + "Features:");
        ps.println(prefix + "  external-general-entities: " + saxParser.getFeature("http://xml.org/sax/features/external-general-entities"));
        ps.println(prefix + "  external-parameter-entities: " + saxParser.getFeature("http://xml.org/sax/features/external-parameter-entities"));
        ps.println(prefix + "  is-standalone: " + saxParser.getFeature("http://xml.org/sax/features/is-standalone"));
        ps.println(prefix + "  lexical-handler/parameter-entities: " + saxParser.getFeature("http://xml.org/sax/features/lexical-handler/parameter-entities"));
        ps.println(prefix + "  namespaces: " + saxParser.getFeature("http://xml.org/sax/features/namespaces"));
        ps.println(prefix + "  namespace-prefixes: " + saxParser.getFeature("http://xml.org/sax/features/namespace-prefixes"));
        ps.println(prefix + "  resolve-dtd-uris: " + saxParser.getFeature("http://xml.org/sax/features/resolve-dtd-uris"));
        ps.println(prefix + "  string-interning: " + saxParser.getFeature("http://xml.org/sax/features/string-interning"));
        ps.println(prefix + "  unicode-normalization-checking: " + saxParser.getFeature("http://xml.org/sax/features/unicode-normalization-checking"));
        ps.println(prefix + "  use-attributes2: " + saxParser.getFeature("http://xml.org/sax/features/use-attributes2"));
        ps.println(prefix + "  use-locator2: " + saxParser.getFeature("http://xml.org/sax/features/use-locator2"));
        ps.println(prefix + "  use-entity-resolver2: " + saxParser.getFeature("http://xml.org/sax/features/use-entity-resolver2"));
        ps.println(prefix + "  validation: " + saxParser.getFeature("http://xml.org/sax/features/validation"));
        ps.println(prefix + "  xmlns-uris: " + saxParser.getFeature("http://xml.org/sax/features/xmlns-uris"));
        ps.println(prefix + "  xml-1.1: " + saxParser.getFeature("http://xml.org/sax/features/xml-1.1"));
        ps.println("Properties: ");
        ps.println(prefix + "  declaration-handler: " + saxParser.getProperty("http://xml.org/sax/properties/declaration-handler"));
        ps.println(prefix + "  document-xml-version: " + saxParser.getProperty("http://xml.org/sax/properties/document-xml-version"));
        ps.println(prefix + "  dom-node: " + saxParser.getProperty("http://xml.org/sax/properties/dom-node"));
        ps.println(prefix + "  lexical-handler: " + saxParser.getProperty("http://xml.org/sax/properties/lexical-handler"));
        ps.println(prefix + "  xml-string: " + saxParser.getProperty("http://xml.org/sax/properties/xml-string"));
    }

    private static LinkedList<UDIFBlock> mergeBlocks(LinkedList<UDIFBlock> blockList) {
        Iterator<UDIFBlock> it = blockList.iterator();
        return DMGExtractor.mergeBlocks(it);
    }

    private static LinkedList<UDIFBlock> mergeBlocks(Iterator<UDIFBlock> it) {
        LinkedList<UDIFBlock> result = new LinkedList<UDIFBlock>();
        UDIFBlock previous = it.next();
        while (previous.getInSize() == 0L && it.hasNext()) {
            previous = it.next();
        }
        while (it.hasNext()) {
            UDIFBlock current = it.next();
            if (current.getInSize() == 0L) continue;
            if (current.getTrueInOffset() == previous.getTrueInOffset() + previous.getInSize()) {
                UDIFBlock mergedBlock;
                previous = mergedBlock = new UDIFBlock(previous.getBlockType(), previous.getReserved(), previous.getOutOffset(), previous.getOutSize() + current.getOutSize(), previous.getInOffset(), previous.getInSize() + current.getInSize(), previous.getOutOffsetCompensation(), previous.getInOffsetCompensation());
                continue;
            }
            result.addLast(previous);
            previous = current;
        }
        result.addLast(previous);
        return result;
    }

    private static class Session {
        public String parseArgsErrorMessage = null;
        public boolean useSaxParser = false;
        public boolean verbose = false;
        public boolean debug = false;
        public boolean graphical = false;
        public String startupCommand = "java DMGExtractor";
        public File dmgFile = null;
        public File isoFile = null;

        private Session() {
        }
    }
}

