/*
 * Decompiled with CFR 0.152.
 */
package lzma;

import lzma.Encoder2;

class LiteralEncoder {
    private Encoder2[] m_Coders;
    private int m_NumPrevBits;
    private int m_NumPosBits;
    private int m_PosMask;

    LiteralEncoder() {
    }

    void create(int numPosBits, int numPrevBits) {
        if (this.m_Coders != null && this.m_NumPrevBits == numPrevBits && this.m_NumPosBits == numPosBits) {
            return;
        }
        this.m_NumPosBits = numPosBits;
        this.m_PosMask = (1 << numPosBits) - 1;
        this.m_NumPrevBits = numPrevBits;
        int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
        this.m_Coders = new Encoder2[numStates];
        for (int i = 0; i < numStates; ++i) {
            this.m_Coders[i] = new Encoder2();
        }
    }

    void init() {
        int numStates = 1 << this.m_NumPrevBits + this.m_NumPosBits;
        for (int i = 0; i < numStates; ++i) {
            this.m_Coders[i].init();
        }
    }

    Encoder2 getSubCoder(int pos, byte prevByte) {
        return this.m_Coders[((pos & this.m_PosMask) << this.m_NumPrevBits) + ((prevByte & 0xFF) >>> 8 - this.m_NumPrevBits)];
    }
}

