/*
 * Decompiled with CFR 0.152.
 */
package lzma;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.Encoder2;
import lzma.LenPriceTableEncoder;
import lzma.LiteralEncoder;
import lzma.LzmaState;
import lzma.Optimal;
import lzma.lz.BinTree;
import lzma.rangecoder.BitTreeEncoder;
import lzma.rangecoder.RangeEncoder;

public class LzmaEncoder {
    public static final int EMatchFinderTypeBT2 = 0;
    public static final int EMatchFinderTypeBT4 = 1;
    private static final int kIfinityPrice = 0xFFFFFFF;
    private static byte[] g_FastPos = new byte[2048];
    private int _state = LzmaState.stateInit();
    private byte _previousByte;
    private int[] _repDistances = new int[4];
    private static final int kDefaultDictionaryLogSize = 22;
    private static final int kNumFastBytesDefault = 32;
    public static final int kNumLenSpecSymbols = 16;
    static final int kNumOpts = 4096;
    private Optimal[] _optimum = new Optimal[4096];
    private BinTree _matchFinder = null;
    private RangeEncoder _rangeEncoder = new RangeEncoder();
    private short[] _isMatch = new short[192];
    private short[] _isRep = new short[12];
    private short[] _isRepG0 = new short[12];
    private short[] _isRepG1 = new short[12];
    private short[] _isRepG2 = new short[12];
    private short[] _isRep0Long = new short[192];
    private BitTreeEncoder[] _posSlotEncoder = new BitTreeEncoder[4];
    private short[] _posEncoders = new short[114];
    private BitTreeEncoder _posAlignEncoder = new BitTreeEncoder(4);
    private LenPriceTableEncoder _lenEncoder = new LenPriceTableEncoder();
    private LenPriceTableEncoder _repMatchLenEncoder = new LenPriceTableEncoder();
    private LiteralEncoder _literalEncoder = new LiteralEncoder();
    private int[] _matchDistances = new int[548];
    private int _numFastBytes = 32;
    private int _longestMatchLength;
    private int _numDistancePairs;
    private int _additionalOffset;
    private int _optimumEndIndex;
    private int _optimumCurrentIndex;
    private boolean _longestMatchWasFound;
    private int[] _posSlotPrices = new int[256];
    private int[] _distancesPrices = new int[512];
    private int[] _alignPrices = new int[16];
    private int _alignPriceCount;
    private int _distTableSize = 44;
    private int _posStateBits = 2;
    private int _posStateMask = 3;
    private int _numLiteralPosStateBits = 0;
    private int _numLiteralContextBits = 3;
    private int _dictionarySize = 0x400000;
    private int _dictionarySizePrev = -1;
    private int _numFastBytesPrev = -1;
    private long nowPos64;
    private boolean _finished;
    private InputStream _inStream;
    private int _matchFinderType = 1;
    private boolean _writeEndMark = false;
    private boolean _needReleaseMFStream = false;
    int[] reps = new int[4];
    int[] repLens = new int[4];
    int backRes;
    private long[] processedInSize = new long[1];
    private long[] processedOutSize = new long[1];
    private boolean[] finished = new boolean[1];
    public static final int kPropSize = 5;
    private int[] tempPrices = new int[128];
    private int _matchPriceCount;

    static int getPosSlot(int pos) {
        if (pos < 2048) {
            return g_FastPos[pos];
        }
        if (pos < 0x200000) {
            return g_FastPos[pos >> 10] + 20;
        }
        return g_FastPos[pos >> 20] + 40;
    }

    static int getPosSlot2(int pos) {
        if (pos < 131072) {
            return g_FastPos[pos >> 6] + 12;
        }
        if (pos < 0x8000000) {
            return g_FastPos[pos >> 16] + 32;
        }
        return g_FastPos[pos >> 26] + 52;
    }

    void baseInit() {
        this._state = LzmaState.stateInit();
        this._previousByte = 0;
        for (int i = 0; i < 4; ++i) {
            this._repDistances[i] = 0;
        }
    }

    void create() {
        if (this._matchFinder == null) {
            BinTree bt = new BinTree();
            int numHashBytes = 4;
            if (this._matchFinderType == 0) {
                numHashBytes = 2;
            }
            bt.setType(numHashBytes);
            this._matchFinder = bt;
        }
        this._literalEncoder.create(this._numLiteralPosStateBits, this._numLiteralContextBits);
        if (this._dictionarySize == this._dictionarySizePrev && this._numFastBytesPrev == this._numFastBytes) {
            return;
        }
        this._matchFinder.create(this._dictionarySize, 4096, this._numFastBytes, 274);
        this._dictionarySizePrev = this._dictionarySize;
        this._numFastBytesPrev = this._numFastBytes;
    }

    public LzmaEncoder() {
        int i;
        for (i = 0; i < 4096; ++i) {
            this._optimum[i] = new Optimal();
        }
        for (i = 0; i < 4; ++i) {
            this._posSlotEncoder[i] = new BitTreeEncoder(6);
        }
    }

    void setWriteEndMarkerMode(boolean writeEndMarker) {
        this._writeEndMark = writeEndMarker;
    }

    void init() {
        this.baseInit();
        this._rangeEncoder.init();
        RangeEncoder.initBitModels(this._isMatch);
        RangeEncoder.initBitModels(this._isRep0Long);
        RangeEncoder.initBitModels(this._isRep);
        RangeEncoder.initBitModels(this._isRepG0);
        RangeEncoder.initBitModels(this._isRepG1);
        RangeEncoder.initBitModels(this._isRepG2);
        RangeEncoder.initBitModels(this._posEncoders);
        this._literalEncoder.init();
        for (int i = 0; i < 4; ++i) {
            this._posSlotEncoder[i].init();
        }
        this._lenEncoder.init(1 << this._posStateBits);
        this._repMatchLenEncoder.init(1 << this._posStateBits);
        this._posAlignEncoder.init();
        this._longestMatchWasFound = false;
        this._optimumEndIndex = 0;
        this._optimumCurrentIndex = 0;
        this._additionalOffset = 0;
    }

    int readMatchDistances() throws IOException {
        int lenRes = 0;
        this._numDistancePairs = this._matchFinder.getMatches(this._matchDistances);
        if (this._numDistancePairs > 0 && (lenRes = this._matchDistances[this._numDistancePairs - 2]) == this._numFastBytes) {
            lenRes += this._matchFinder.getMatchLen(lenRes - 1, this._matchDistances[this._numDistancePairs - 1], 273 - lenRes);
        }
        ++this._additionalOffset;
        return lenRes;
    }

    void movePos(int num) throws IOException {
        if (num > 0) {
            this._matchFinder.skip(num);
            this._additionalOffset += num;
        }
    }

    int getRepLen1Price(int state, int posState) {
        return RangeEncoder.getPrice0(this._isRepG0[state]) + RangeEncoder.getPrice0(this._isRep0Long[(state << 4) + posState]);
    }

    int getPureRepPrice(int repIndex, int state, int posState) {
        int price;
        if (repIndex == 0) {
            price = RangeEncoder.getPrice0(this._isRepG0[state]);
            price += RangeEncoder.getPrice1(this._isRep0Long[(state << 4) + posState]);
        } else {
            price = RangeEncoder.getPrice1(this._isRepG0[state]);
            if (repIndex == 1) {
                price += RangeEncoder.getPrice0(this._isRepG1[state]);
            } else {
                price += RangeEncoder.getPrice1(this._isRepG1[state]);
                price += RangeEncoder.getPrice(this._isRepG2[state], repIndex - 2);
            }
        }
        return price;
    }

    int getRepPrice(int repIndex, int len, int state, int posState) {
        int price = this._repMatchLenEncoder.getPrice(len - 2, posState);
        return price + this.getPureRepPrice(repIndex, state, posState);
    }

    int getPosLenPrice(int pos, int len, int posState) {
        int lenToPosState = LzmaState.getLenToPosState(len);
        int price = pos < 128 ? this._distancesPrices[lenToPosState * 128 + pos] : this._posSlotPrices[(lenToPosState << 6) + LzmaEncoder.getPosSlot2(pos)] + this._alignPrices[pos & 0xF];
        return price + this._lenEncoder.getPrice(len - 2, posState);
    }

    int backward(int cur) {
        int posPrev;
        this._optimumEndIndex = cur;
        int posMem = this._optimum[cur].PosPrev;
        int backMem = this._optimum[cur].BackPrev;
        do {
            if (this._optimum[cur].Prev1IsChar) {
                this._optimum[posMem].makeAsChar();
                this._optimum[posMem].PosPrev = posMem - 1;
                if (this._optimum[cur].Prev2) {
                    this._optimum[posMem - 1].Prev1IsChar = false;
                    this._optimum[posMem - 1].PosPrev = this._optimum[cur].PosPrev2;
                    this._optimum[posMem - 1].BackPrev = this._optimum[cur].BackPrev2;
                }
            }
            posPrev = posMem;
            int backCur = backMem;
            backMem = this._optimum[posPrev].BackPrev;
            posMem = this._optimum[posPrev].PosPrev;
            this._optimum[posPrev].BackPrev = backCur;
            this._optimum[posPrev].PosPrev = cur;
        } while ((cur = posPrev) > 0);
        this.backRes = this._optimum[0].BackPrev;
        this._optimumCurrentIndex = this._optimum[0].PosPrev;
        return this._optimumCurrentIndex;
    }

    /*
     * Unable to fully structure code
     */
    int getOptimum(int position) throws IOException {
        if (this._optimumEndIndex != this._optimumCurrentIndex) {
            lenRes = this._optimum[this._optimumCurrentIndex].PosPrev - this._optimumCurrentIndex;
            this.backRes = this._optimum[this._optimumCurrentIndex].BackPrev;
            this._optimumCurrentIndex = this._optimum[this._optimumCurrentIndex].PosPrev;
            return lenRes;
        }
        this._optimumEndIndex = 0;
        this._optimumCurrentIndex = 0;
        if (!this._longestMatchWasFound) {
            lenMain = this.readMatchDistances();
        } else {
            lenMain = this._longestMatchLength;
            this._longestMatchWasFound = false;
        }
        numDistancePairs = this._numDistancePairs;
        numAvailableBytes = this._matchFinder.getNumAvailableBytes() + 1;
        if (numAvailableBytes < 2) {
            this.backRes = -1;
            return 1;
        }
        if (numAvailableBytes > 273) {
            numAvailableBytes = 273;
        }
        repMaxIndex = 0;
        for (i = 0; i < 4; ++i) {
            this.reps[i] = this._repDistances[i];
            this.repLens[i] = this._matchFinder.getMatchLen(-1, this.reps[i], 273);
            if (this.repLens[i] <= this.repLens[repMaxIndex]) continue;
            repMaxIndex = i;
        }
        if (this.repLens[repMaxIndex] >= this._numFastBytes) {
            this.backRes = repMaxIndex;
            lenRes = this.repLens[repMaxIndex];
            this.movePos(lenRes - 1);
            return lenRes;
        }
        if (lenMain >= this._numFastBytes) {
            this.backRes = this._matchDistances[numDistancePairs - 1] + 4;
            this.movePos(lenMain - 1);
            return lenMain;
        }
        currentByte = this._matchFinder.getIndexByte(-1);
        matchByte = this._matchFinder.getIndexByte(0 - this._repDistances[0] - 1 - 1);
        if (lenMain < 2 && currentByte != matchByte && this.repLens[repMaxIndex] < 2) {
            this.backRes = -1;
            return 1;
        }
        this._optimum[0].State = this._state;
        posState = position & this._posStateMask;
        this._optimum[1].Price = RangeEncoder.getPrice0(this._isMatch[(this._state << 4) + posState]) + this._literalEncoder.getSubCoder(position, this._previousByte).getPrice(LzmaState.stateIsCharState(this._state) == false, matchByte, currentByte);
        this._optimum[1].makeAsChar();
        matchPrice = RangeEncoder.getPrice1(this._isMatch[(this._state << 4) + posState]);
        repMatchPrice = matchPrice + RangeEncoder.getPrice1(this._isRep[this._state]);
        if (matchByte == currentByte && (shortRepPrice = repMatchPrice + this.getRepLen1Price(this._state, posState)) < this._optimum[1].Price) {
            this._optimum[1].Price = shortRepPrice;
            this._optimum[1].makeAsShortRep();
        }
        v0 = lenEnd = lenMain >= this.repLens[repMaxIndex] ? lenMain : this.repLens[repMaxIndex];
        if (lenEnd < 2) {
            this.backRes = this._optimum[1].BackPrev;
            return 1;
        }
        this._optimum[1].PosPrev = 0;
        this._optimum[0].Backs0 = this.reps[0];
        this._optimum[0].Backs1 = this.reps[1];
        this._optimum[0].Backs2 = this.reps[2];
        this._optimum[0].Backs3 = this.reps[3];
        len = lenEnd;
        do {
            this._optimum[len--].Price = 0xFFFFFFF;
        } while (len >= 2);
        for (i = 0; i < 4; ++i) {
            repLen = this.repLens[i];
            if (repLen < 2) continue;
            price = repMatchPrice + this.getPureRepPrice(i, this._state, posState);
            do {
                curAndLenPrice = price + this._repMatchLenEncoder.getPrice(repLen - 2, posState);
                optimum = this._optimum[repLen];
                if (curAndLenPrice >= optimum.Price) continue;
                optimum.Price = curAndLenPrice;
                optimum.PosPrev = 0;
                optimum.BackPrev = i;
                optimum.Prev1IsChar = false;
            } while (--repLen >= 2);
        }
        normalMatchPrice = matchPrice + RangeEncoder.getPrice0(this._isRep[this._state]);
        v1 = len = this.repLens[0] >= 2 ? this.repLens[0] + 1 : 2;
        if (len <= lenMain) {
            offs = 0;
            while (len > this._matchDistances[offs]) {
                offs += 2;
            }
            while (true) {
                distance = this._matchDistances[offs + 1];
                curAndLenPrice = normalMatchPrice + this.getPosLenPrice(distance, len, posState);
                optimum = this._optimum[len];
                if (curAndLenPrice < optimum.Price) {
                    optimum.Price = curAndLenPrice;
                    optimum.PosPrev = 0;
                    optimum.BackPrev = distance + 4;
                    optimum.Prev1IsChar = false;
                }
                if (len == this._matchDistances[offs] && (offs += 2) == numDistancePairs) break;
                ++len;
            }
        }
        cur = 0;
        block6: while (true) {
            if (++cur == lenEnd) {
                return this.backward(cur);
            }
            newLen = this.readMatchDistances();
            numDistancePairs = this._numDistancePairs;
            if (newLen >= this._numFastBytes) {
                this._longestMatchLength = newLen;
                this._longestMatchWasFound = true;
                return this.backward(cur);
            }
            ++position;
            posPrev = this._optimum[cur].PosPrev;
            if (this._optimum[cur].Prev1IsChar) {
                --posPrev;
                if (this._optimum[cur].Prev2) {
                    state = this._optimum[this._optimum[cur].PosPrev2].State;
                    state = this._optimum[cur].BackPrev2 < 4 ? LzmaState.stateUpdateRep(state) : LzmaState.stateUpdateMatch(state);
                } else {
                    state = this._optimum[posPrev].State;
                }
                state = LzmaState.stateUpdateChar(state);
            } else {
                state = this._optimum[posPrev].State;
            }
            if (posPrev == cur - 1) {
                state = this._optimum[cur].isShortRep() ? LzmaState.stateUpdateShortRep(state) : LzmaState.stateUpdateChar(state);
            } else {
                if (this._optimum[cur].Prev1IsChar && this._optimum[cur].Prev2) {
                    posPrev = this._optimum[cur].PosPrev2;
                    pos = this._optimum[cur].BackPrev2;
                    state = LzmaState.stateUpdateRep(state);
                } else {
                    pos = this._optimum[cur].BackPrev;
                    state = pos < 4 ? LzmaState.stateUpdateRep(state) : LzmaState.stateUpdateMatch(state);
                }
                opt = this._optimum[posPrev];
                if (pos < 4) {
                    if (pos == 0) {
                        this.reps[0] = opt.Backs0;
                        this.reps[1] = opt.Backs1;
                        this.reps[2] = opt.Backs2;
                        this.reps[3] = opt.Backs3;
                    } else if (pos == 1) {
                        this.reps[0] = opt.Backs1;
                        this.reps[1] = opt.Backs0;
                        this.reps[2] = opt.Backs2;
                        this.reps[3] = opt.Backs3;
                    } else if (pos == 2) {
                        this.reps[0] = opt.Backs2;
                        this.reps[1] = opt.Backs0;
                        this.reps[2] = opt.Backs1;
                        this.reps[3] = opt.Backs3;
                    } else {
                        this.reps[0] = opt.Backs3;
                        this.reps[1] = opt.Backs0;
                        this.reps[2] = opt.Backs1;
                        this.reps[3] = opt.Backs2;
                    }
                } else {
                    this.reps[0] = pos - 4;
                    this.reps[1] = opt.Backs0;
                    this.reps[2] = opt.Backs1;
                    this.reps[3] = opt.Backs2;
                }
            }
            this._optimum[cur].State = state;
            this._optimum[cur].Backs0 = this.reps[0];
            this._optimum[cur].Backs1 = this.reps[1];
            this._optimum[cur].Backs2 = this.reps[2];
            this._optimum[cur].Backs3 = this.reps[3];
            curPrice = this._optimum[cur].Price;
            currentByte = this._matchFinder.getIndexByte(-1);
            matchByte = this._matchFinder.getIndexByte(0 - this.reps[0] - 1 - 1);
            posState = position & this._posStateMask;
            curAnd1Price = curPrice + RangeEncoder.getPrice0(this._isMatch[(state << 4) + posState]) + this._literalEncoder.getSubCoder(position, this._matchFinder.getIndexByte(-2)).getPrice(LzmaState.stateIsCharState(state) == false, matchByte, currentByte);
            nextOptimum = this._optimum[cur + 1];
            nextIsChar = false;
            if (curAnd1Price < nextOptimum.Price) {
                nextOptimum.Price = curAnd1Price;
                nextOptimum.PosPrev = cur;
                nextOptimum.makeAsChar();
                nextIsChar = true;
            }
            matchPrice = curPrice + RangeEncoder.getPrice1(this._isMatch[(state << 4) + posState]);
            repMatchPrice = matchPrice + RangeEncoder.getPrice1(this._isRep[state]);
            if (matchByte == currentByte && (nextOptimum.PosPrev >= cur || nextOptimum.BackPrev != 0) && (shortRepPrice = repMatchPrice + this.getRepLen1Price(state, posState)) <= nextOptimum.Price) {
                nextOptimum.Price = shortRepPrice;
                nextOptimum.PosPrev = cur;
                nextOptimum.makeAsShortRep();
                nextIsChar = true;
            }
            numAvailableBytesFull = this._matchFinder.getNumAvailableBytes() + 1;
            numAvailableBytes = numAvailableBytesFull = Math.min(4095 - cur, numAvailableBytesFull);
            if (numAvailableBytes < 2) continue;
            if (numAvailableBytes > this._numFastBytes) {
                numAvailableBytes = this._numFastBytes;
            }
            if (!nextIsChar && matchByte != currentByte && (lenTest2 = this._matchFinder.getMatchLen(0, this.reps[0], t = Math.min(numAvailableBytesFull - 1, this._numFastBytes))) >= 2) {
                state2 = LzmaState.stateUpdateChar(state);
                posStateNext = position + 1 & this._posStateMask;
                nextRepMatchPrice = curAnd1Price + RangeEncoder.getPrice1(this._isMatch[(state2 << 4) + posStateNext]) + RangeEncoder.getPrice1(this._isRep[state2]);
                offset = cur + 1 + lenTest2;
                while (lenEnd < offset) {
                    this._optimum[++lenEnd].Price = 0xFFFFFFF;
                }
                curAndLenPrice = nextRepMatchPrice + this.getRepPrice(0, lenTest2, state2, posStateNext);
                optimum = this._optimum[offset];
                if (curAndLenPrice < optimum.Price) {
                    optimum.Price = curAndLenPrice;
                    optimum.PosPrev = cur + 1;
                    optimum.BackPrev = 0;
                    optimum.Prev1IsChar = true;
                    optimum.Prev2 = false;
                }
            }
            startLen = 2;
            for (repIndex = 0; repIndex < 4; ++repIndex) {
                lenTest = this._matchFinder.getMatchLen(-1, this.reps[repIndex], numAvailableBytes);
                if (lenTest < 2) continue;
                lenTestTemp = lenTest;
                while (true) {
                    if (lenEnd < cur + lenTest) {
                        this._optimum[++lenEnd].Price = 0xFFFFFFF;
                        continue;
                    }
                    curAndLenPrice = repMatchPrice + this.getRepPrice(repIndex, lenTest, state, posState);
                    optimum = this._optimum[cur + lenTest];
                    if (curAndLenPrice < optimum.Price) {
                        optimum.Price = curAndLenPrice;
                        optimum.PosPrev = cur;
                        optimum.BackPrev = repIndex;
                        optimum.Prev1IsChar = false;
                    }
                    if (--lenTest < 2) break;
                }
                lenTest = lenTestTemp;
                if (repIndex == 0) {
                    startLen = lenTest + 1;
                }
                if (lenTest >= numAvailableBytesFull || (lenTest2 = this._matchFinder.getMatchLen(lenTest, this.reps[repIndex], t = Math.min(numAvailableBytesFull - 1 - lenTest, this._numFastBytes))) < 2) continue;
                state2 = LzmaState.stateUpdateRep(state);
                posStateNext = position + lenTest & this._posStateMask;
                curAndLenCharPrice = repMatchPrice + this.getRepPrice(repIndex, lenTest, state, posState) + RangeEncoder.getPrice0(this._isMatch[(state2 << 4) + posStateNext]) + this._literalEncoder.getSubCoder(position + lenTest, this._matchFinder.getIndexByte(lenTest - 1 - 1)).getPrice(true, this._matchFinder.getIndexByte(lenTest - 1 - (this.reps[repIndex] + 1)), this._matchFinder.getIndexByte(lenTest - 1));
                state2 = LzmaState.stateUpdateChar(state2);
                posStateNext = position + lenTest + 1 & this._posStateMask;
                nextMatchPrice = curAndLenCharPrice + RangeEncoder.getPrice1(this._isMatch[(state2 << 4) + posStateNext]);
                nextRepMatchPrice = nextMatchPrice + RangeEncoder.getPrice1(this._isRep[state2]);
                offset = lenTest + 1 + lenTest2;
                while (lenEnd < cur + offset) {
                    this._optimum[++lenEnd].Price = 0xFFFFFFF;
                }
                curAndLenPrice = nextRepMatchPrice + this.getRepPrice(0, lenTest2, state2, posStateNext);
                optimum = this._optimum[cur + offset];
                if (curAndLenPrice >= optimum.Price) continue;
                optimum.Price = curAndLenPrice;
                optimum.PosPrev = cur + lenTest + 1;
                optimum.BackPrev = 0;
                optimum.Prev1IsChar = true;
                optimum.Prev2 = true;
                optimum.PosPrev2 = cur;
                optimum.BackPrev2 = repIndex;
            }
            if (newLen > numAvailableBytes) {
                newLen = numAvailableBytes;
                numDistancePairs = 0;
                while (newLen > this._matchDistances[numDistancePairs]) {
                    numDistancePairs += 2;
                }
                this._matchDistances[numDistancePairs] = newLen;
                numDistancePairs += 2;
            }
            if (newLen < startLen) continue;
            normalMatchPrice = matchPrice + RangeEncoder.getPrice0(this._isRep[state]);
            while (lenEnd < cur + newLen) {
                this._optimum[++lenEnd].Price = 0xFFFFFFF;
            }
            offs = 0;
            while (startLen > this._matchDistances[offs]) {
                offs += 2;
            }
            lenTest = startLen;
            while (true) {
                curBack = this._matchDistances[offs + 1];
                curAndLenPrice = normalMatchPrice + this.getPosLenPrice(curBack, lenTest, posState);
                optimum = this._optimum[cur + lenTest];
                if (curAndLenPrice < optimum.Price) {
                    optimum.Price = curAndLenPrice;
                    optimum.PosPrev = cur;
                    optimum.BackPrev = curBack + 4;
                    optimum.Prev1IsChar = false;
                }
                if (lenTest == this._matchDistances[offs]) {
                    if (lenTest < numAvailableBytesFull && (lenTest2 = this._matchFinder.getMatchLen(lenTest, curBack, t = Math.min(numAvailableBytesFull - 1 - lenTest, this._numFastBytes))) >= 2) {
                        state2 = LzmaState.stateUpdateMatch(state);
                        posStateNext = position + lenTest & this._posStateMask;
                        curAndLenCharPrice = curAndLenPrice + RangeEncoder.getPrice0(this._isMatch[(state2 << 4) + posStateNext]) + this._literalEncoder.getSubCoder(position + lenTest, this._matchFinder.getIndexByte(lenTest - 1 - 1)).getPrice(true, this._matchFinder.getIndexByte(lenTest - (curBack + 1) - 1), this._matchFinder.getIndexByte(lenTest - 1));
                        state2 = LzmaState.stateUpdateChar(state2);
                        posStateNext = position + lenTest + 1 & this._posStateMask;
                        nextMatchPrice = curAndLenCharPrice + RangeEncoder.getPrice1(this._isMatch[(state2 << 4) + posStateNext]);
                        nextRepMatchPrice = nextMatchPrice + RangeEncoder.getPrice1(this._isRep[state2]);
                        offset = lenTest + 1 + lenTest2;
                        while (lenEnd < cur + offset) {
                            this._optimum[++lenEnd].Price = 0xFFFFFFF;
                        }
                        curAndLenPrice = nextRepMatchPrice + this.getRepPrice(0, lenTest2, state2, posStateNext);
                        optimum = this._optimum[cur + offset];
                        if (curAndLenPrice < optimum.Price) {
                            optimum.Price = curAndLenPrice;
                            optimum.PosPrev = cur + lenTest + 1;
                            optimum.BackPrev = 0;
                            optimum.Prev1IsChar = true;
                            optimum.Prev2 = true;
                            optimum.PosPrev2 = cur;
                            optimum.BackPrev2 = curBack + 4;
                        }
                    }
                    if ((offs += 2) != numDistancePairs) ** break;
                    continue block6;
                }
                ++lenTest;
            }
            break;
        }
    }

    boolean changePair(int smallDist, int bigDist) {
        int kDif = 7;
        return smallDist < 1 << 32 - kDif && bigDist >= smallDist << kDif;
    }

    void writeEndMarker(int posState) throws IOException {
        if (!this._writeEndMark) {
            return;
        }
        this._rangeEncoder.encode(this._isMatch, (this._state << 4) + posState, 1);
        this._rangeEncoder.encode(this._isRep, this._state, 0);
        this._state = LzmaState.stateUpdateMatch(this._state);
        int len = 2;
        this._lenEncoder.encode(this._rangeEncoder, len - 2, posState);
        int posSlot = 63;
        int lenToPosState = LzmaState.getLenToPosState(len);
        this._posSlotEncoder[lenToPosState].encode(this._rangeEncoder, posSlot);
        int footerBits = 30;
        int posReduced = (1 << footerBits) - 1;
        this._rangeEncoder.encodeDirectBits(posReduced >> 4, footerBits - 4);
        this._posAlignEncoder.reverseEncode(this._rangeEncoder, posReduced & 0xF);
    }

    void flush(int nowPos) throws IOException {
        this.releaseMFStream();
        this.writeEndMarker(nowPos & this._posStateMask);
        this._rangeEncoder.flushData();
        this._rangeEncoder.flushStream();
    }

    public void codeOneBlock(long[] inSize, long[] outSize, boolean[] finished) throws IOException {
        inSize[0] = 0L;
        outSize[0] = 0L;
        finished[0] = true;
        if (this._inStream != null) {
            this._matchFinder.setStream(this._inStream);
            this._matchFinder.init();
            this._needReleaseMFStream = true;
            this._inStream = null;
        }
        if (this._finished) {
            return;
        }
        this._finished = true;
        long progressPosValuePrev = this.nowPos64;
        if (this.nowPos64 == 0L) {
            if (this._matchFinder.getNumAvailableBytes() == 0) {
                this.flush((int)this.nowPos64);
                return;
            }
            this.readMatchDistances();
            int posState = (int)this.nowPos64 & this._posStateMask;
            this._rangeEncoder.encode(this._isMatch, (this._state << 4) + posState, 0);
            this._state = LzmaState.stateUpdateChar(this._state);
            byte curByte = this._matchFinder.getIndexByte(0 - this._additionalOffset);
            this._literalEncoder.getSubCoder((int)this.nowPos64, this._previousByte).encode(this._rangeEncoder, curByte);
            this._previousByte = curByte;
            --this._additionalOffset;
            ++this.nowPos64;
        }
        if (this._matchFinder.getNumAvailableBytes() == 0) {
            this.flush((int)this.nowPos64);
            return;
        }
        while (true) {
            int len = this.getOptimum((int)this.nowPos64);
            int pos = this.backRes;
            int posState = (int)this.nowPos64 & this._posStateMask;
            int complexState = (this._state << 4) + posState;
            if (len == 1 && pos == -1) {
                this._rangeEncoder.encode(this._isMatch, complexState, 0);
                byte curByte = this._matchFinder.getIndexByte(0 - this._additionalOffset);
                Encoder2 subCoder = this._literalEncoder.getSubCoder((int)this.nowPos64, this._previousByte);
                if (!LzmaState.stateIsCharState(this._state)) {
                    byte matchByte = this._matchFinder.getIndexByte(0 - this._repDistances[0] - 1 - this._additionalOffset);
                    subCoder.encodeMatched(this._rangeEncoder, matchByte, curByte);
                } else {
                    subCoder.encode(this._rangeEncoder, curByte);
                }
                this._previousByte = curByte;
                this._state = LzmaState.stateUpdateChar(this._state);
            } else {
                this._rangeEncoder.encode(this._isMatch, complexState, 1);
                if (pos < 4) {
                    this._rangeEncoder.encode(this._isRep, this._state, 1);
                    if (pos == 0) {
                        this._rangeEncoder.encode(this._isRepG0, this._state, 0);
                        if (len == 1) {
                            this._rangeEncoder.encode(this._isRep0Long, complexState, 0);
                        } else {
                            this._rangeEncoder.encode(this._isRep0Long, complexState, 1);
                        }
                    } else {
                        this._rangeEncoder.encode(this._isRepG0, this._state, 1);
                        if (pos == 1) {
                            this._rangeEncoder.encode(this._isRepG1, this._state, 0);
                        } else {
                            this._rangeEncoder.encode(this._isRepG1, this._state, 1);
                            this._rangeEncoder.encode(this._isRepG2, this._state, pos - 2);
                        }
                    }
                    if (len == 1) {
                        this._state = LzmaState.stateUpdateShortRep(this._state);
                    } else {
                        this._repMatchLenEncoder.encode(this._rangeEncoder, len - 2, posState);
                        this._state = LzmaState.stateUpdateRep(this._state);
                    }
                    int distance = this._repDistances[pos];
                    if (pos != 0) {
                        for (int i = pos; i >= 1; --i) {
                            this._repDistances[i] = this._repDistances[i - 1];
                        }
                        this._repDistances[0] = distance;
                    }
                } else {
                    this._rangeEncoder.encode(this._isRep, this._state, 0);
                    this._state = LzmaState.stateUpdateMatch(this._state);
                    this._lenEncoder.encode(this._rangeEncoder, len - 2, posState);
                    int posSlot = LzmaEncoder.getPosSlot(pos -= 4);
                    int lenToPosState = LzmaState.getLenToPosState(len);
                    this._posSlotEncoder[lenToPosState].encode(this._rangeEncoder, posSlot);
                    if (posSlot >= 4) {
                        int footerBits = (posSlot >> 1) - 1;
                        int baseVal = (2 | posSlot & 1) << footerBits;
                        int posReduced = pos - baseVal;
                        if (posSlot < 14) {
                            BitTreeEncoder.reverseEncode(this._posEncoders, baseVal - posSlot - 1, this._rangeEncoder, footerBits, posReduced);
                        } else {
                            this._rangeEncoder.encodeDirectBits(posReduced >> 4, footerBits - 4);
                            this._posAlignEncoder.reverseEncode(this._rangeEncoder, posReduced & 0xF);
                            ++this._alignPriceCount;
                        }
                    }
                    int distance = pos;
                    for (int i = 3; i >= 1; --i) {
                        this._repDistances[i] = this._repDistances[i - 1];
                    }
                    this._repDistances[0] = distance;
                    ++this._matchPriceCount;
                }
                this._previousByte = this._matchFinder.getIndexByte(len - 1 - this._additionalOffset);
            }
            this._additionalOffset -= len;
            this.nowPos64 += (long)len;
            if (this._additionalOffset != 0) continue;
            if (this._matchPriceCount >= 128) {
                this.fillDistancesPrices();
            }
            if (this._alignPriceCount >= 16) {
                this.fillAlignPrices();
            }
            inSize[0] = this.nowPos64;
            outSize[0] = this._rangeEncoder.getProcessedSizeAdd();
            if (this._matchFinder.getNumAvailableBytes() == 0) {
                this.flush((int)this.nowPos64);
                return;
            }
            if (this.nowPos64 - progressPosValuePrev >= 4096L) break;
        }
        this._finished = false;
        finished[0] = false;
    }

    void releaseMFStream() {
        if (this._matchFinder != null && this._needReleaseMFStream) {
            this._matchFinder.releaseStream();
            this._needReleaseMFStream = false;
        }
    }

    void setOutStream(OutputStream outStream) {
        this._rangeEncoder.setStream(outStream);
    }

    void releaseOutStream() {
        this._rangeEncoder.releaseStream();
    }

    void releaseStreams() {
        this.releaseMFStream();
        this.releaseOutStream();
    }

    void setStreams(InputStream inStream, OutputStream outStream) {
        this._inStream = inStream;
        this._finished = false;
        this.create();
        this.setOutStream(outStream);
        this.init();
        this.fillDistancesPrices();
        this.fillAlignPrices();
        this._lenEncoder.setTableSize(this._numFastBytes + 1 - 2);
        this._lenEncoder.updateTables(1 << this._posStateBits);
        this._repMatchLenEncoder.setTableSize(this._numFastBytes + 1 - 2);
        this._repMatchLenEncoder.updateTables(1 << this._posStateBits);
        this.nowPos64 = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void code(InputStream inStream, OutputStream outStream) throws IOException {
        this._needReleaseMFStream = false;
        try {
            this.setStreams(inStream, outStream);
            do {
                this.codeOneBlock(this.processedInSize, this.processedOutSize, this.finished);
            } while (!this.finished[0]);
            return;
        }
        finally {
            this.releaseStreams();
        }
    }

    public byte[] getCoderProperties() {
        byte[] properties = new byte[5];
        properties[0] = (byte)((this._posStateBits * 5 + this._numLiteralPosStateBits) * 9 + this._numLiteralContextBits);
        for (int i = 0; i < 4; ++i) {
            properties[1 + i] = (byte)(this._dictionarySize >> 8 * i);
        }
        return properties;
    }

    public void writeCoderProperties(OutputStream outStream) throws IOException {
        byte[] properties = this.getCoderProperties();
        outStream.write(properties, 0, 5);
    }

    void fillDistancesPrices() {
        int posSlot;
        for (int i = 4; i < 128; ++i) {
            posSlot = LzmaEncoder.getPosSlot(i);
            int footerBits = (posSlot >> 1) - 1;
            int baseVal = (2 | posSlot & 1) << footerBits;
            this.tempPrices[i] = BitTreeEncoder.reverseGetPrice(this._posEncoders, baseVal - posSlot - 1, footerBits, i - baseVal);
        }
        for (int lenToPosState = 0; lenToPosState < 4; ++lenToPosState) {
            int i;
            BitTreeEncoder encoder = this._posSlotEncoder[lenToPosState];
            int st = lenToPosState << 6;
            for (posSlot = 0; posSlot < this._distTableSize; ++posSlot) {
                this._posSlotPrices[st + posSlot] = encoder.getPrice(posSlot);
            }
            for (posSlot = 14; posSlot < this._distTableSize; ++posSlot) {
                int n = st + posSlot;
                this._posSlotPrices[n] = this._posSlotPrices[n] + ((posSlot >> 1) - 1 - 4 << 6);
            }
            int st2 = lenToPosState * 128;
            for (i = 0; i < 4; ++i) {
                this._distancesPrices[st2 + i] = this._posSlotPrices[st + i];
            }
            while (i < 128) {
                this._distancesPrices[st2 + i] = this._posSlotPrices[st + LzmaEncoder.getPosSlot(i)] + this.tempPrices[i];
                ++i;
            }
        }
        this._matchPriceCount = 0;
    }

    void fillAlignPrices() {
        for (int i = 0; i < 16; ++i) {
            this._alignPrices[i] = this._posAlignEncoder.reverseGetPrice(i);
        }
        this._alignPriceCount = 0;
    }

    public boolean setAlgorithm(int algorithm) {
        return true;
    }

    public boolean setDictionarySize(int dictionarySize) {
        int kDicLogSizeMaxCompress = 29;
        if (dictionarySize < 1 || dictionarySize > 1 << kDicLogSizeMaxCompress) {
            return false;
        }
        this._dictionarySize = dictionarySize;
        int dicLogSize = 0;
        while (dictionarySize > 1 << dicLogSize) {
            ++dicLogSize;
        }
        this._distTableSize = dicLogSize * 2;
        return true;
    }

    public boolean setNumFastBytes(int numFastBytes) {
        if (numFastBytes < 5 || numFastBytes > 273) {
            return false;
        }
        this._numFastBytes = numFastBytes;
        return true;
    }

    public boolean setMatchFinder(int matchFinderIndex) {
        if (matchFinderIndex < 0 || matchFinderIndex > 2) {
            return false;
        }
        int matchFinderIndexPrev = this._matchFinderType;
        this._matchFinderType = matchFinderIndex;
        if (this._matchFinder != null && matchFinderIndexPrev != this._matchFinderType) {
            this._dictionarySizePrev = -1;
            this._matchFinder = null;
        }
        return true;
    }

    public boolean setLcLpPb(int lc, int lp, int pb) {
        if (lp < 0 || lp > 4 || lc < 0 || lc > 8 || pb < 0 || pb > 4) {
            return false;
        }
        this._numLiteralPosStateBits = lp;
        this._numLiteralContextBits = lc;
        this._posStateBits = pb;
        this._posStateMask = (1 << this._posStateBits) - 1;
        return true;
    }

    public void setEndMarkerMode(boolean endMarkerMode) {
        this._writeEndMark = endMarkerMode;
    }

    static {
        int kFastSlots = 22;
        int c = 2;
        LzmaEncoder.g_FastPos[0] = 0;
        LzmaEncoder.g_FastPos[1] = 1;
        for (int slotFast = 2; slotFast < kFastSlots; ++slotFast) {
            int k = 1 << (slotFast >> 1) - 1;
            int j = 0;
            while (j < k) {
                LzmaEncoder.g_FastPos[c] = (byte)slotFast;
                ++j;
                ++c;
            }
        }
    }
}

