/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;

class ConcurrentBufferInputStream
extends InputStream {
    protected ArrayBlockingQueue<byte[]> q;
    protected byte[] buf = null;
    protected int next = 0;
    protected boolean eof = false;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    private ConcurrentBufferInputStream(ArrayBlockingQueue<byte[]> q) {
        if (DEBUG) {
            dbg.printf("%s << %s%n", this, q);
        }
        this.q = q;
        this.eof = false;
    }

    static InputStream create(ArrayBlockingQueue<byte[]> q) {
        ConcurrentBufferInputStream in = new ConcurrentBufferInputStream(q);
        return in;
    }

    protected byte[] guarded_take() throws IOException {
        try {
            return this.q.take();
        }
        catch (InterruptedException exn) {
            throw new InterruptedIOException(exn.getMessage());
        }
    }

    protected boolean prepareAndCheckEOF() throws IOException {
        if (this.eof) {
            return true;
        }
        if (this.buf == null || this.next >= this.buf.length) {
            this.buf = this.guarded_take();
            this.next = 0;
            if (this.buf.length == 0) {
                this.eof = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.prepareAndCheckEOF()) {
            return -1;
        }
        byte x = this.buf[this.next];
        ++this.next;
        return x & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.prepareAndCheckEOF()) {
            return -1;
        }
        int k = this.buf.length - this.next;
        if (len < k) {
            k = len;
        }
        System.arraycopy(this.buf, this.next, b, off, k);
        this.next += k;
        return k;
    }

    public String toString() {
        return String.format("cbIn@%x", this.hashCode());
    }

    static {
        String ds = null;
        try {
            ds = System.getProperty("DEBUG_ConcurrentBuffer");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = ds != null;
    }
}

