/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;
import lzma.LzmaEncoder;
import net.contrapunctus.lzma.ConcurrentBufferInputStream;
import net.contrapunctus.lzma.ConcurrentBufferOutputStream;
import net.contrapunctus.lzma.LzmaOutputStream;

class EncoderThread
extends Thread {
    public static final Integer DEFAULT_DICT_SZ_POW2 = new Integer(20);
    protected ArrayBlockingQueue<byte[]> q = ConcurrentBufferOutputStream.newQueue();
    protected InputStream in = ConcurrentBufferInputStream.create(this.q);
    protected OutputStream out;
    protected LzmaEncoder enc;
    protected IOException exn;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    EncoderThread(OutputStream _out, Integer dictSzPow2, Integer fastBytes) {
        this.out = _out;
        this.enc = new LzmaEncoder();
        this.exn = null;
        this.enc.setDictionarySize(1 << (dictSzPow2 == null ? DEFAULT_DICT_SZ_POW2 : dictSzPow2));
        if (fastBytes != null) {
            this.enc.setNumFastBytes(fastBytes);
        }
        if (DEBUG) {
            dbg.printf("%s << %s (%s)%n", this, this.in, this.q);
        }
    }

    @Override
    public void run() {
        block6: {
            try {
                this.enc.setEndMarkerMode(true);
                if (LzmaOutputStream.LZMA_HEADER) {
                    this.enc.writeCoderProperties(this.out);
                    long fileSize = -1L;
                    for (int i = 0; i < 8; ++i) {
                        this.out.write((int)(fileSize >>> 8 * i) & 0xFF);
                    }
                }
                if (DEBUG) {
                    dbg.printf("%s begins%n", this);
                }
                this.enc.code(this.in, this.out);
                if (DEBUG) {
                    dbg.printf("%s ends%n", this);
                }
                this.out.close();
            }
            catch (IOException _exn) {
                this.exn = _exn;
                if (!DEBUG) break block6;
                dbg.printf("%s exception: %s%n", this.exn.getMessage());
            }
        }
    }

    @Override
    public String toString() {
        return String.format("Enc@%x", this.hashCode());
    }

    static {
        String ds = null;
        try {
            ds = System.getProperty("DEBUG_LzmaCoders");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = ds != null;
    }
}

