/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io;

import info.ata4.io.DataInputBridge;
import info.ata4.io.DataInputExtended;
import info.ata4.io.Struct;
import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.io.socket.ByteBufferSocket;
import info.ata4.io.socket.ChannelSocket;
import info.ata4.io.socket.DataSocket;
import info.ata4.io.socket.FileChannelSocket;
import info.ata4.io.socket.IOSocket;
import info.ata4.io.socket.StreamSocket;
import info.ata4.io.util.HalfFloat;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.commons.lang3.ArrayUtils;

public class DataInputReader
extends DataInputBridge
implements DataInputExtended {
    private static final Charset DEFAULT_CHARSET = Charset.forName("ASCII");

    public static DataInputReader newReader(DataInput in) {
        return new DataInputReader(new DataSocket(in));
    }

    public static DataInputReader newReader(InputStream is) {
        return new DataInputReader(new StreamSocket(is));
    }

    public static DataInputReader newReader(ByteBuffer bb) {
        return new DataInputReader(new ByteBufferSocket(bb));
    }

    public static DataInputReader newReader(ReadableByteChannel fc) {
        return new DataInputReader(new ChannelSocket(fc));
    }

    public static DataInputReader newReader(FileChannel fc) throws IOException {
        return new DataInputReader(new FileChannelSocket(fc, StandardOpenOption.READ));
    }

    public static DataInputReader newReader(Path file) throws IOException {
        return new DataInputReader(new FileChannelSocket(file, StandardOpenOption.READ));
    }

    public static DataInputReader newBufferedReader(Path file) throws IOException {
        InputStream is = Files.newInputStream(file, StandardOpenOption.READ);
        return DataInputReader.newReader(new BufferedInputStream(is, 65536));
    }

    public static DataInputReader newMappedReader(Path file) throws IOException {
        return DataInputReader.newReader(ByteBufferUtils.openReadOnly(file));
    }

    public static DataInputReader newReader(RandomAccessFile raf) throws IOException {
        return DataInputReader.newReader(raf.getChannel());
    }

    public DataInputReader(IOSocket socket) {
        super(socket);
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public BigInteger readUnsignedLong() throws IOException {
        byte[] raw = new byte[8];
        this.readFully(raw);
        if (!this.isSwap()) {
            ArrayUtils.reverse((byte[])raw);
        }
        return new BigInteger(raw);
    }

    @Override
    public float readHalf() throws IOException {
        int hbits = this.readUnsignedShort();
        return HalfFloat.intBitsToFloat(hbits);
    }

    private String readString(int limit, Charset charset, boolean padded) throws IOException {
        byte b;
        int length;
        if (limit <= 0) {
            throw new IllegalArgumentException("Invalid limit");
        }
        byte[] raw = new byte[limit];
        for (length = 0; length < raw.length && (b = this.readByte()) != 0; ++length) {
            raw[length] = b;
        }
        if (padded) {
            this.skipBytes(limit - length - 1);
        }
        return new String(raw, 0, length, charset);
    }

    @Override
    public String readStringNull(int limit, Charset charset) throws IOException {
        return this.readString(limit, charset, false);
    }

    @Override
    public String readStringNull(int limit) throws IOException {
        return this.readStringNull(limit, DEFAULT_CHARSET);
    }

    @Override
    public String readStringNull() throws IOException {
        return this.readStringNull(256);
    }

    @Override
    public String readStringPadded(int limit, Charset charset) throws IOException {
        return this.readString(limit, charset, true);
    }

    @Override
    public String readStringPadded(int limit) throws IOException {
        return this.readStringPadded(limit, DEFAULT_CHARSET);
    }

    @Override
    public String readStringFixed(int length, Charset charset) throws IOException {
        byte[] raw = new byte[length];
        this.readFully(raw);
        return new String(raw, charset);
    }

    @Override
    public String readStringFixed(int length) throws IOException {
        return this.readStringFixed(length, DEFAULT_CHARSET);
    }

    @Override
    public String readStringInt(int limit, Charset charset) throws IOException {
        int length = this.readInt();
        if (limit > 0 && length > limit) {
            return null;
        }
        return this.readStringFixed(length, charset);
    }

    @Override
    public String readStringInt(int limit) throws IOException {
        return this.readStringInt(limit, DEFAULT_CHARSET);
    }

    @Override
    public String readStringInt() throws IOException {
        return this.readStringInt(0);
    }

    @Override
    public String readStringShort(int limit, Charset charset) throws IOException {
        int length = this.readUnsignedShort();
        if (limit > 0 && length > limit) {
            return null;
        }
        return this.readStringFixed(length, charset);
    }

    @Override
    public String readStringShort(int limit) throws IOException {
        return this.readStringShort(limit, DEFAULT_CHARSET);
    }

    @Override
    public String readStringShort() throws IOException {
        return this.readStringShort(0);
    }

    @Override
    public String readStringByte(Charset charset) throws IOException {
        int length = this.readUnsignedByte();
        return this.readStringFixed(length, charset);
    }

    @Override
    public String readStringByte() throws IOException {
        return this.readStringByte(DEFAULT_CHARSET);
    }

    @Override
    public void readBuffer(ByteBuffer dst) throws IOException {
        ByteBuffer buffer = this.getSocket().getByteBuffer();
        if (buffer != null) {
            dst.put(buffer);
            return;
        }
        ReadableByteChannel channel = this.getSocket().getReadableByteChannel();
        if (channel != null) {
            while (dst.hasRemaining() && channel.read(dst) != -1) {
            }
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void readStruct(Struct struct) throws IOException {
        struct.read(this);
    }

    @Override
    public void align(int align) throws IOException {
        int rem;
        if (align > 0 && (rem = (int)(this.position() % (long)align)) != 0) {
            this.skipBytes(align - rem);
        }
    }
}

