/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io;

import info.ata4.io.IOBridge;
import info.ata4.io.socket.IOSocket;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.io.EndianUtils;

public class DataOutputBridge
extends IOBridge
implements DataOutput {
    private final DataOutput out;

    public DataOutputBridge(IOSocket socket) {
        super(socket);
        this.out = socket.getDataOutput();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.isManualSwap()) {
            v = EndianUtils.swapShort((short)((short)v));
        }
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.isManualSwap()) {
            v = EndianUtils.swapInteger((int)v);
        }
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.isManualSwap()) {
            v = EndianUtils.swapLong((long)v);
        }
        this.out.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        if (this.isManualSwap()) {
            this.writeInt(Float.floatToRawIntBits(v));
        } else {
            this.out.writeFloat(v);
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        if (this.isManualSwap()) {
            this.writeLong(Double.doubleToRawLongBits(v));
        } else {
            this.out.writeDouble(v);
        }
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.out.writeUTF(s);
    }
}

