/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io;

import info.ata4.io.DataOutputBridge;
import info.ata4.io.DataOutputExtended;
import info.ata4.io.Struct;
import info.ata4.io.buffer.ByteBufferUtils;
import info.ata4.io.socket.ByteBufferSocket;
import info.ata4.io.socket.ChannelSocket;
import info.ata4.io.socket.DataSocket;
import info.ata4.io.socket.FileChannelSocket;
import info.ata4.io.socket.IOSocket;
import info.ata4.io.socket.StreamSocket;
import info.ata4.io.util.HalfFloat;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class DataOutputWriter
extends DataOutputBridge
implements DataOutputExtended {
    private static final Charset DEFAULT_CHARSET = Charset.forName("ASCII");

    public static DataOutputWriter newWriter(DataOutput out) {
        return new DataOutputWriter(new DataSocket(out));
    }

    public static DataOutputWriter newWriter(OutputStream os) {
        return new DataOutputWriter(new StreamSocket(os));
    }

    public static DataOutputWriter newWriter(ByteBuffer bb) {
        return new DataOutputWriter(new ByteBufferSocket(bb));
    }

    public static DataOutputWriter newWriter(WritableByteChannel fc) {
        return new DataOutputWriter(new ChannelSocket(fc));
    }

    public static DataOutputWriter newWriter(FileChannel fc) throws IOException {
        return new DataOutputWriter(new FileChannelSocket(fc, StandardOpenOption.WRITE));
    }

    public static DataOutputWriter newWriter(Path file) throws IOException {
        return new DataOutputWriter(new FileChannelSocket(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));
    }

    public static DataOutputWriter newBufferedWriter(Path file) throws IOException {
        OutputStream os = Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        return new DataOutputWriter(new StreamSocket(new BufferedOutputStream(os, 65536)));
    }

    public static DataOutputWriter newMappedWriter(Path file) throws IOException {
        return DataOutputWriter.newWriter(ByteBufferUtils.openReadWrite(file));
    }

    public static DataOutputWriter newWriter(RandomAccessFile raf) throws IOException {
        return DataOutputWriter.newWriter(raf.getChannel());
    }

    public DataOutputWriter(IOSocket socket) {
        super(socket);
    }

    @Override
    public void writeHalf(float f) throws IOException {
        int sval = HalfFloat.floatToIntBits(f);
        this.writeShort(sval);
    }

    @Override
    public void writeStringNull(String str, Charset charset) throws IOException {
        this.writeStringFixed(str, charset);
        this.writeByte(0);
    }

    @Override
    public void writeStringNull(String str) throws IOException {
        this.writeStringNull(str, DEFAULT_CHARSET);
    }

    @Override
    public void writeStringPadded(String str, int padding, Charset charset) throws IOException {
        int nullBytes = padding - str.length();
        if (nullBytes < 0) {
            throw new IllegalArgumentException("Invalid padding");
        }
        this.writeStringFixed(str, charset);
        this.skipBytes(nullBytes);
    }

    @Override
    public void writeStringPadded(String str, int padding) throws IOException {
        this.writeStringPadded(str, padding, DEFAULT_CHARSET);
    }

    @Override
    public void writeStringFixed(String str, Charset charset) throws IOException {
        this.write(str.getBytes(charset));
    }

    @Override
    public void writeStringFixed(String str) throws IOException {
        this.writeStringFixed(str, DEFAULT_CHARSET);
    }

    @Override
    public void writeStringInt(String str, Charset charset) throws IOException {
        this.writeInt(str.length());
        this.writeStringFixed(str, charset);
    }

    @Override
    public void writeStringInt(String str) throws IOException {
        this.writeStringInt(str, DEFAULT_CHARSET);
    }

    @Override
    public void writeStringShort(String str, Charset charset) throws IOException {
        if (str.length() > 65535) {
            throw new IllegalArgumentException("String is too long");
        }
        this.writeShort(str.length());
        this.writeStringFixed(str, charset);
    }

    @Override
    public void writeStringShort(String str) throws IOException {
        this.writeStringShort(str, DEFAULT_CHARSET);
    }

    @Override
    public void writeStringByte(String str, Charset charset) throws IOException {
        if (str.length() > 255) {
            throw new IllegalArgumentException("String is too long");
        }
        this.writeByte(str.length());
        this.writeStringFixed(str, charset);
    }

    @Override
    public void writeStringByte(String str) throws IOException {
        this.writeStringByte(str, DEFAULT_CHARSET);
    }

    @Override
    public void writeBuffer(ByteBuffer src) throws IOException {
        ByteBuffer buffer = this.getSocket().getByteBuffer();
        if (buffer != null) {
            buffer.put(src);
            return;
        }
        WritableByteChannel channel = this.getSocket().getWritableByteChannel();
        if (channel != null) {
            while (src.hasRemaining()) {
                channel.write(src);
            }
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeStruct(Struct struct) throws IOException {
        struct.write(this);
    }

    @Override
    public void skipBytes(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeByte(0);
        }
    }

    @Override
    public void align(int align) throws IOException {
        int rem;
        if (align > 0 && (rem = (int)(this.position() % (long)align)) != 0) {
            this.skipBytes(align - rem);
        }
    }
}

