/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io;

import info.ata4.io.SeekOrigin;
import info.ata4.io.Seekable;
import info.ata4.io.Swappable;
import info.ata4.io.socket.IOSocket;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class IOBridge
implements Swappable,
Seekable,
Closeable {
    private final IOSocket socket;
    private final ByteBuffer bb;
    private boolean swap;

    public IOBridge(IOSocket socket) {
        this.socket = socket;
        this.bb = socket.getByteBuffer();
        if (this.bb != null) {
            this.swap = this.bb.order() != ByteOrder.BIG_ENDIAN;
        }
    }

    public IOSocket getSocket() {
        return this.socket;
    }

    @Override
    public boolean isSwap() {
        return this.swap;
    }

    @Override
    public void setSwap(boolean swap) {
        this.swap = swap;
        if (this.bb != null) {
            this.bb.order(swap ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        }
    }

    protected boolean isManualSwap() {
        return this.swap && this.bb == null;
    }

    public boolean isSeekable() {
        return this.socket.getSeekable() != null;
    }

    public Seekable getSeekable() {
        Seekable seekable = this.socket.getSeekable();
        if (seekable != null) {
            return seekable;
        }
        throw new UnsupportedOperationException("Seeking not supported");
    }

    @Override
    public void seek(long where, SeekOrigin dir) throws IOException {
        this.getSeekable().seek(where, dir);
    }

    @Override
    public void position(long where) throws IOException {
        this.getSeekable().position(where);
    }

    @Override
    public long position() throws IOException {
        return this.getSeekable().position();
    }

    @Override
    public long capacity() throws IOException {
        return this.getSeekable().capacity();
    }

    @Override
    public long remaining() throws IOException {
        return this.getSeekable().remaining();
    }

    @Override
    public boolean hasRemaining() throws IOException {
        return this.getSeekable().hasRemaining();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }
}

