/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.buffer;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferDataInput
implements DataInput {
    private final ByteBuffer buf;

    public ByteBufferDataInput(ByteBuffer buf) {
        this.buf = buf;
    }

    public ByteBuffer getByteBuffer() {
        return this.buf;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        try {
            this.buf.get(b);
        }
        catch (BufferUnderflowException ex) {
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            this.buf.get(b, off, len);
        }
        catch (BufferUnderflowException ex) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        try {
            n = Math.min(n, this.buf.remaining());
            this.buf.position(this.buf.position() + n);
            return n;
        }
        catch (IllegalArgumentException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        try {
            return this.buf.get() != 0;
        }
        catch (BufferUnderflowException ex) {
            throw new EOFException();
        }
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.buf.get();
        }
        catch (BufferUnderflowException ex) {
            throw new EOFException();
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.buf.getShort();
        }
        catch (BufferUnderflowException ex) {
            throw new EOFException();
        }
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        try {
            return this.buf.getChar();
        }
        catch (BufferUnderflowException ex) {
            throw new EOFException();
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.buf.getInt();
        }
        catch (BufferUnderflowException ex) {
            throw new EOFException();
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.buf.getLong();
        }
        catch (BufferUnderflowException ex) {
            throw new EOFException();
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            return this.buf.getFloat();
        }
        catch (BufferUnderflowException ex) {
            throw new EOFException();
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            return this.buf.getDouble();
        }
        catch (BufferUnderflowException ex) {
            throw new EOFException();
        }
    }

    @Override
    public String readLine() throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            int c = 0;
            while (this.buf.hasRemaining() && c != 10) {
                sb.append((char)c);
                c = this.buf.get();
            }
            return sb.toString();
        }
        catch (BufferUnderflowException ex) {
            throw new EOFException();
        }
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

