/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.socket.provider;

import info.ata4.io.socket.IOSocket;
import info.ata4.io.socket.provider.SocketProvider;
import info.ata4.io.streams.InverseDataOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.io.output.ClosedOutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class OutputStreamProvider
extends SocketProvider<OutputStream> {
    public OutputStreamProvider(IOSocket socket) {
        super(socket);
    }

    @Override
    protected OutputStream create() {
        WritableByteChannel chan = this.socket.getWritableByteChannel();
        if (chan != null) {
            return Channels.newOutputStream(chan);
        }
        DataOutput output = this.socket.getDataOutput();
        if (output != null) {
            return new InverseDataOutputStream(output);
        }
        return null;
    }

    @Override
    protected OutputStream getCloseShield(OutputStream instance) {
        return new CloseShieldOutputStream(instance);
    }

    private class CloseShieldOutputStream
    extends ProxyOutputStream {
        private CloseShieldOutputStream(OutputStream out) {
            super(out);
        }

        public void close() throws IOException {
            this.out.flush();
            this.out = new ClosedOutputStream();
        }
    }
}

