/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.streams;

import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
extends InputStream {
    private final InputStream is;
    private int bitBuffer;
    private int bitCount;
    private int bits = 8;

    public BitInputStream(InputStream is) {
        this.is = is;
    }

    public int getBitLength() {
        return this.bits;
    }

    public void setBitLength(int bits) {
        if (bits < 1 || bits > 32) {
            throw new IllegalArgumentException();
        }
        this.bits = bits;
    }

    @Override
    public int read() throws IOException {
        if (this.bits == 8 && this.bitCount == 0) {
            return this.is.read();
        }
        while (this.bitCount < this.bits) {
            int b = this.is.read();
            if (b == -1) {
                return b;
            }
            this.bitBuffer |= b << this.bitCount;
            this.bitCount += 8;
        }
        int code = this.bitBuffer;
        if (this.bitCount != 32) {
            code &= (1 << this.bits) - 1;
        }
        this.bitBuffer >>= this.bits;
        this.bitCount -= this.bits;
        return code;
    }

    public int read(int bits) throws IOException {
        this.setBitLength(bits);
        return this.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkByteArrayOp();
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkByteArrayOp();
        return super.read(b, off, len);
    }

    private void checkByteArrayOp() {
        if (this.bits > 8) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

