/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.io.util;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.FilenameUtils;

public class PathUtils {
    private PathUtils() {
    }

    public static String getExtension(Path path) {
        return FilenameUtils.getExtension((String)path.getFileName().toString());
    }

    public static Path changeExtension(Path path, String ext) {
        String name = path.getFileName().toString();
        name = FilenameUtils.removeExtension((String)name);
        if (ext == null) {
            return path.resolveSibling(name);
        }
        return path.resolveSibling(name + '.' + ext);
    }

    public static Path removeExtension(Path path) {
        return PathUtils.changeExtension(path, null);
    }

    public static Path append(Path path, String ext) {
        return path.resolveSibling(path.getFileName().toString() + ext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDirectoryEmpty(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(path);){
            boolean bl = !ds.iterator().hasNext();
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void deleteQuietly(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

