select A.DataAfast,
       A.DataTermino,
       A.DiasLicMedica,
       S.TipoSit,
       A.PerdeFerias,
       S.PerdeFerias SitPerdeFerias
from Afastamento A 
join Situacao S 
  on S.CodigoSit = A.CodigoSit
where A.CodigoEmpresa = :pCodigoEmpresa
  and A.CodigoFuncContr = :pCodigoFuncContr
  and ({TIMESTAMPADD('DAY', {IFNULL(A.DiasLicMedica, 0)} , (A.DataAfast))}) <= :DataTermino
  and (A.DataTermino >= :DataAfast
       or A.DataTermino is null)
order by A.DataAfast