  select %0:s
         af.DataTermino,
         pc.DataInicialFolha,
         pc.DataFinalFolha,
         pc.Compet
    from Afastamento af,
         Situacao st,
         PeriodoCalculo pc
   where af.CodigoEmpresa = :CodigoEmpresa
     and af.CodigoFuncContr    = :CodigoFuncContr
     and af.DiasLicMedica is not null
     and st.CodigoSit     = af.CodigoSit
     and st.TipoSit       in ('03', '04', '05', '06', '08')
     and DataAfast        < af.DataTermino
     and pc.CodigoEmpresa = af.CodigoEmpresa
     and pc.Compet        >= :Compet
     and pc.CodigoTipoCalc between 1 and 6
     and AF.DataAfast     <= pc.DataFinalFolha
     and AF.DataTermino   >= pc.DataInicialFolha
union
  select af.DataAfast,
         af.DataTermino,
         pc.DataInicialFolha,
         pc.DataFinalFolha,
         pc.Compet
    from Afastamento af,
         Situacao st,
         PeriodoCalculo pc
   where af.CodigoEmpresa = :CodigoEmpresa
     and af.CodigoFuncContr    = :CodigoFuncContr
     and af.DiasLicMedica is null
     and st.CodigoSit     = af.CodigoSit
     and st.TipoSit       in ('03', '04', '05', '06', '08')
     and af.DataAfast     < af.DataTermino
     and pc.CodigoEmpresa = af.CodigoEmpresa
     and pc.Compet        >= :Compet
     and pc.CodigoTipoCalc between 1 and 6
     and AF.DataAfast     <= pc.DataFinalFolha
     and AF.DataTermino   >= pc.DataInicialFolha
order by 1, 2
