    Select AF.CodigoEmpresa,
           AF.CodigoFuncContr,
           FL.CodigoEstab,
           FL.DataTransf,
           AF.DataAfast,
           AF.DataTermino,
           AF.CodigoSit,
           SIT.DescrSit,
           coalesce(AF.PerdeFerias, 0) PerdeFerias,
           coalesce(AF.Perde13, 0) Perde13,
           coalesce(AF.PerdeDsr, 0) PerdeDsr,
           case
             when (AF.DataAfast is not null) and (AF.DataTermino is not null) then
               (AF.DataTermino - AF.DataAfast) + 1
           end DiasAfastamento
      from FuncContrato FC
           %0:s
      join Afastamento AF
        on AF.CodigoEmpresa = FC.CodigoEmpresa
       and AF.CodigoFuncContr = FC.CodigoFuncContr
       and AF.CodigoSit <> '02'
      join Situacao SIT
        on SIT.CodigoSit = AF.Codigosit
 left join FuncLocal FL
        on FL.CodigoEmpresa = AF.CodigoEmpresa
       and FL.CodigoFuncContr = AF.CodigoFuncContr
       and FL.DataTransf = (Select Max(FLa.DataTransf)
                              from FuncLocal FLa
                             where FLa.CodigoEmpresa = AF.CodigoEmpresa
                               and FLa.CodigoFuncContr = AF.CodigoFuncContr
                               and FLa.DataTransf <= AF.DataAfast)
 Inner join FuncSindicato FS
        on FS.CodigoEmpresa = AF.CodigoEmpresa
       and FS.CodigoFuncContr = AF.CodigoFuncContr
       and FS.DataInicial = (Select Max(FSa.DataInicial)
                               from FuncSindicato FSa
                              where FSa.CodigoEmpresa = AF.CodigoEmpresa
                                and FSa.CodigoFuncContr = AF.CodigoFuncContr
                                and FSa.DataInicial <= AF.DataAfast)