  select distinct E.CodigoEstrut,
                  FPC.SeqCalculo,
                  CE.BaseEvento,
                  CE.ValorEvento,
                  PC.Compet,
                  FPC.DataPgtoFolha DataPgto
             from PeriodoCalculo PC,
                  CalculoEvento CE,
                  Evento E,
                  FuncPerCalculo FPC
            where CE.CodigoEmpresa     = :CodigoEmpresa
              and CE.CodigoFuncContr        = :CodigoFuncContr
              and PC.CodigoEmpresa     = FPC.CodigoEmpresa
              and PC.CodigoPerCalculo  = FPC.CodigoPerCalculo
              and FPC.CodigoEmpresa    = CE.CodigoEmpresa
              and FPC.CodigoPerCalculo = CE.CodigoPerCalculo
              and FPC.CodigoFuncContr       = CE.CodigoFuncContr
              and E.CodigoEvento       = CE.CodigoEvento
              and (( Extract (year from FPC.DataPgtoFolha) = :AnoPgto
              and  Extract (month from FPC.DataPgtoFolha)  = :MesPgto)
               or (PC.Compet = :Compet))
         order by 1, 2
