  select PC.Compet,
         PC.DataInicialFolha,
         PC.DataFinalFolha,
         EV.RemunSegDesempPenAnt,
         CE.CodigoEvento,
         CE.ValorEvento
    from PeriodoCalculo PC
    join CalculoEvento CE
      on PC.CodigoEmpresa = CE.CodigoEmpresa
     and PC.CodigoPerCalculo = CE.CodigoPerCalculo
    join Evento EV
      on CE.CodigoEvento = EV.CodigoEvento and CE.CodigoEvento = 5060
   where PC.CodigoEmpresa = :CodigoEmpresa
     and PC.Compet >= :Compet
	 and PC.Compet < {TIMESTAMPADD(MONTH, 3, CAST(:Compet AS DATE))}
     and PC.CodigoTipoCalc between 1 and 7
     and CE.CodigoFuncContr = :CodigoFuncContr
     and EV.RemunSegDesempPenAnt between 1 and 2
order by 1, 5, 6


