  select E.CodigoEstrut,
         E.CodigoEvento,
         P.Compet,
         P.CodigoPerCalculo,
         A.BaseEvento,
         A.ReferEvento,
         A.ValorEvento,
         P.CodigoTipoCalc,
         F.DataPgtoFolha as DataPgto,
         P.DataInicialFolha,
         P.DataFinalFolha,
         P.CodigoPerCalcCompl,
         F.CodigoEmpresaImp,
         F.CodigoPerCalcImp,
         F.SeqCalculo,
         E.TipoEvento
    from PeriodoCalculo P,
         FuncPerCalculo F,
         CalculoEvento A,
         Evento E
   where A.CodigoEmpresa    = :CodigoEmpresa
     and A.CodigoFuncContr       = :CodigoFuncContr
     and (P.Compet         >= :pCompet
      or (F.SeqCalculo       = :pSeqCalculo
     and E.CodigoProced in (27, 28, 81)))
     and (not :Data between P.DataInicialFolha and P.DataFinalFolha
      or P.CodigoTipoCalc in (8, 20, 21, 23))
     and F.CodigoEmpresa    = A.CodigoEmpresa
     and F.CodigoFuncContr       = A.CodigoFuncContr
     and F.CodigoPerCalculo = A.CodigoPerCalculo
     and P.CodigoEmpresa    = A.CodigoEmpresa
     and P.CodigoPerCalculo = A.CodigoPerCalculo
     and A.CodigoEvento     = E.CodigoEvento

union

select E.CodigoEstrut,
       E.CodigoEvento,
       R.DataResc,
       null CodigoPerCalculo,
       RE.BaseEvento,
       RE.ReferEvento,
       RE.ValorEvento,
       case R.TipoRescisao when 1 then 60 
       else 61 end CodigoTipoCalc,
       R.DataPgtoResc DataPgto,
       null DataInicialFolha,
       null DataFinalFolha, 
       null CodigoPerCalcCompl,
       null CodigoEmpresaImp,
       null CodigoPerCalcImp,
       0 SeqCalculo,
       E.TipoEvento
from Rescisao R,
     RescisaoEvento RE,
     Evento E
where RE.CodigoEmpresa  = :CodigoEmpresa
  and RE.CodigoFuncContr     = :CodigoFuncContr
  and R.CodigoEmpresa   = RE.CodigoEmpresa
  and R.CodigoFuncContr      = RE.CodigoFuncContr
  and R.Complementar    = RE.Complementar
  and ((R.TipoRescisao = 1 and R.DataResc between :DataInicial and :DataFinal)
   or  (R.TipoRescisao  <> 1 and R.DataPgtoResc between :DataInicial and :DataFinal))
  and E.CodigoEvento    = RE.CodigoEvento
order by 1, 2, 3, 4
