Merge into CalculoEvento D
using(select cast(:CodigoEmpresaDest as Integer) CodigoEmpresa, 
             cast(:CodigoFuncContrDest as Integer) CodigoFuncContr, 
             p.CodigoPerCalculo,
             ce.CodigoEvento, 
			 ce.BaseEvento, 
			 ce.ReferEvento,
             ce.ValorEvento, 
			 ce.OrigemDado, 
			 ce.CodigoUsuario, 
			 ce.DataHoraLcto
    from CalculoEvento ce, 
	     PeriodoCalculo pc, 
		 PeriodoCalculo p
   where ce.CodigoEmpresa = :CodigoEmpresaOrig
     and ce.CodigoFuncContr = :CodigoFuncContrOrig
     and pc.CodigoEmpresa = ce.CodigoEmpresa
     and pc.CodigoPerCalculo = ce.CodigoPerCalculo
     and p.CodigoEmpresa = :CodigoEmpresaDest
     and p.Compet = pc.Compet
     and p.CodigoTipoCalc = :CodigoTipoCalc
	 and PC.CodigoTipoCalc = 1 )O
on (O.CodigoEmpresa = D.CodigoEmpresa
and O.CodigoFuncContr = D.CodigoFuncContr
and O.CodigoPerCalculo = D.CodigoPerCalculo
and O.CodigoEvento = D.CodigoEvento)
when  not MATCHED then
insert (CodigoEmpresa, 
        CodigoFuncContr, 
		CodigoPerCalculo,
        CodigoEvento, 
		BaseEvento, 
		ReferEvento,
        ValorEvento, 
		OrigemDado, 
		CodigoUsuario, 
		DataHoraLcto)
values (O.CodigoEmpresa, 
        O.CodigoFuncContr, 
		O.CodigoPerCalculo,
        O.CodigoEvento, 
		O.BaseEvento, 
		O.ReferEvento,
        O.ValorEvento, 
		O.OrigemDado, 
		O.CodigoUsuario, 
		O.DataHoraLcto)
 
