select CR.CodigoEmpresa,
          CR.CodigoFuncContr,
          CR.CodigoEvento,
          CR.ReferEvento,
          CR.ValorEvento,
          CR.BaseEvento,
          E.TipoEvento,
          E.DescrEvento,
          E.CodigoProced,
          E.CodigoEstrut,
          TC.TipoContr,
          E.ReferEvento TipoReferEvento,
          FP.NomeFunc,
          SC.TipoQuebraCaixa,
          FL.ClassifOrgan,
          FS.TipoSalario
     from FuncContrato F
     join FuncPessoa FP
       on FP.CodigoFuncPessoa = F.CodigoFuncPessoa 
     join FuncSalario FS on F.CodigoEmpresa = FS.CodigoEmpresa
      and F.CodigoFuncContr = FS.CodigoFuncContr,
          FuncPerCalculo FPC
inner Join SindConvencao SC
       on SC.CodigoSind = FPC.CodigoSind
      and SC.DataInicial = (Select Max(SCa.DataInicial)
                              from SindConvencao SCa
                             where SCa.CodigoSind = SC.CodigoSind
                               and SCa.DataInicial <= :pDataFinalFolha),
          FuncLocal FL,
          CalculoRateio CR,
          Evento E,
          TipoContrato TC
    where CR.CodigoEvento = E.CodigoEvento
      and CR.CodigoEmpresa = :pCodigoEmpresa
      and CR.CodigoPerCalculo = :pCodigoPerCalculo
      and CR.CodigoOutEmp = :pCodigoOutEmp
      and CR.CodigoEmpresa = FPC.CodigoEmpresa
      and CR.CodigoFuncContr = FPC.CodigoFuncContr
      and CR.CodigoPerCalculo = FPC.CodigoPerCalculo
      and FPC.CodigoEmpresa = FL.CodigoEmpresa
      and FPC.CodigoFuncContr = FL.CodigoFuncContr
      and FPC.DataLocal = FL.DataTransf
      and FL.CodigoEstab = :pCodigoEstab
      and CR.CodigoEmpresa = F.CodigoEmpresa
      and CR.CodigoFuncContr = F.CodigoFuncContr
      and F.CodigoTipoContr = TC.CodigoTipoContr
      and FS.DataInicial = FPC.DataSalario
      and FS.SEQ = FPC.SeqFuncSalario
 order by 1,
          13,
          2,
          3