select fp.CPFFunc,
       fpc.DataPgtoFolha DataPgto,
       e.LocalInformeDirf,
       e.CodigoEstrut,
       e.CodigoEvento,
       e.DescrEvento,
       sum(ce.ValorEvento * e.FormaInformeDirf) Valor
 from FuncContrato x,
      FuncPerCalculo fpc,
      CalculoEvento ce,
      Evento e,
      PeriodoCalculo pc
 join FuncPessoa Fp
      on FP.codigoFuncPessoa = X.codigoFuncPessoa
where 1 = 1
   %s
  and x.CodigoEmpresa = fpc.CodigoEmpresa
  and x.CodigoFuncContr = fpc.CodigoFuncContr
  and fpc.DataPgtoFolha between :pCompetIni and :pCompetFin
  and fpc.CodigoEmpresa = ce.CodigoEmpresa
  and fpc.CodigoPerCalculo = ce.CodigoPerCalculo
  and fpc.CodigoFuncContr = ce.CodigoFuncContr
  and ce.CodigoEvento = e.CodigoEvento
  and e.OrigemDadoDirf = 1
  and e.LocalInformeDirf <> 0
  and e.FormaInformeDirf <> 0
  and PC.CodigoEmpresa = FPC.CodigoEmpresa
  and PC.CodigoPerCalculo = FPC.CodigoPerCalculo
  and PC.DataFinalFolha >= FPC.DataLocal
group by fp.CPFFunc,
         fpc.DataPgtoFolha,
         e.LocalInformeDirf,
         e.CodigoEstrut,
         e.CodigoEvento,
         e.DescrEvento
union all
select fp.CPFFunc,
       rf.DataPgto DataPgto,
       e.LocalInformeDirf,
       e.CodigoEstrut,
       e.CodigoEvento,
       e.DescrEvento,
       sum(fe.ValorEvento * e.FormaInformeDirf) Valor
 from FuncContrato x,
      ReciboFerias rf,
      FeriasEvento fe,
      Evento e
 join FuncPessoa Fp
     on FP.codigoFuncPessoa = X.codigoFuncPessoa  
where 1 = 1
   %s
  and x.CodigoFuncContr = rf.CodigoFuncContr
  and x.CodigoEmpresa = rf.CodigoEmpresa
  and rf.DataPgto between :pCompetIni and :pCompetFin
  and rf.CodigoEmpresa = fe.CodigoEmpresa
  and rf.CodigoFuncContr = fe.CodigoFuncContr
  and rf.DataInicial = fe.DataInicial
  and rf.DataInicialFerias= fe.DataInicialFerias
  and rf.SeqReciboFerias = fe.SeqReciboFerias
  and fe.CodigoEvento = e.CodigoEvento
  and rf.TipoRecibo <> 3
  and e.OrigemDadoDirf = 2
  and e.LocalInformeDirf <> 0
  and e.FormaInformeDirf <> 0
  and (rf.DataPgto >= x.DataTransfEmp or x.DataTransfEmp is null)
group by fp.CPFFunc,
         rf.DataPgto,
         e.LocalInformeDirf,
         e.CodigoEstrut,
         e.CodigoEvento,
         e.DescrEvento
union all
select fp.CPFFunc,
       r.DataPgtoResc DataPgto,
       e.LocalInformeDirf,
       e.CodigoEstrut,
       e.CodigoEvento,
       e.DescrEvento,
       sum(re.ValorEvento * e.FormaInformeDirf) Valor
from FuncContrato x,
     Rescisao r,
     RescisaoEvento re,
     Evento e
 join FuncPessoa Fp
    on FP.codigoFuncPessoa = X.codigoFuncPessoa  
where 1 = 1
   %s
  and x.CodigoFuncContr = r.CodigoFuncContr
  and x.CodigoEmpresa = r.CodigoEmpresa
  and r.DataPgtoResc between :pCompetIni and :pCompetFin
  and r.CodigoEmpresa = re.CodigoEmpresa
  and r.CodigoFuncContr = re.CodigoFuncContr
  and r.Complementar = re.Complementar
  and re.CodigoEvento = e.CodigoEvento
  and e.OrigemDadoDirf = 1
  and e.LocalInformeDirf <> 0
  and e.FormaInformeDirf <> 0
group by fp.CPFFunc,
          r.DataPgtoResc,
          e.LocalInformeDirf,
          e.CodigoEstrut,
          e.CodigoEvento,
          e.DescrEvento
