select fp.CPFFunc,
       pj.NomeBenef,
       pj.CPFBenef,
       cp.CodigoEstrut,
       cp.DataPgto,
       pj.Parentesco,
       pj.DataNasc,
       sum(cp.ValorPensao) ValorPensao
 from FuncContrato x
 join PensaoJud pj
   on pj.CodigoEmpresa = x.CodigoEmpresa
  and pj.CodigoFuncContr    = x.CodigoFuncContr
 join CalculoPensao cp
   on cp.CodigoEmpresa = pj.CodigoEmpresa
  and cp.CodigoFuncContr    = pj.CodigoFuncContr
  and cp.CodigoBenef   = pj.CodigoBenef
  join funcPessoa fp
   on fp.CodigoFuncPessoa = X.CodigoFuncPessoa
 where cp.DataPgto between :pCompetIni and :pCompetFin
    %0:s
   and cp.CodigoEstrut = '97.02.02' 
   and cp.SeqReciboFerias is not null
   and (cp.DataPgto >= x.DataTransfEmp or x.DataTransfEmp is null)
 group by fp.CPFFunc,
          pj.NomeBenef,
          pj.CPFBenef,
          cp.CodigoEstrut,
          cp.DataPgto,
          pj.Parentesco,
          pj.DataNasc
having sum(cp.ValorPensao) > 0
union 
select fp.CPFFunc,
       pj.NomeBenef,
       pj.CPFBenef,
       cp.CodigoEstrut,
       cp.DataPgto,
       pj.Parentesco,
       pj.DataNasc,
       sum(cp.ValorPensao) ValorPensao
 from FuncContrato x
 join PensaoJud pj
   on pj.CodigoEmpresa = x.CodigoEmpresa
  and pj.CodigoFuncContr    = x.CodigoFuncContr
 join CalculoPensao cp
   on cp.CodigoEmpresa = pj.CodigoEmpresa
  and cp.CodigoFuncContr    = pj.CodigoFuncContr
  and cp.CodigoBenef   = pj.CodigoBenef
  join funcPessoa fp
   on fp.CodigoFuncPessoa = X.CodigoFuncPessoa
 where cp.DataPgto between :pCompetIni and :pCompetFin
   %0:s
   and not(cp.CodigoEstrut = '97.02.02') 	
   and (cp.DataPgto >= x.DataTransfEmp or x.DataTransfEmp is null)
 group by fp.CPFFunc,
          pj.NomeBenef,
          pj.CPFBenef,
          cp.CodigoEstrut,
          cp.DataPgto,
          pj.Parentesco,
          pj.DataNasc
having sum(cp.ValorPensao) > 0
 order by 1, 7, 2

