select FP.CpfFunc,
       ad.DataAdto Data,
       sum(ad.ValorAdto) BaseIRRF,
       sum(ad.ValorIRRF) ValorIRRF
  from FuncContrato f
  join funcPessoa FP
    on Fp.codigofuncPessoa = F.codigofuncPessoa
  join AdtoFerias ad
    on ad.CodigoEmpresa   = f.CodigoEmpresa
   and ad.CodigoFuncContr = f.CodigoFuncContr
where f.CodigoEmpresa = :pCodigoEmpresa
  and ad.DataAdto between :pCompetIni and :pCompetFin
  and (ad.DataAdto >= f.DataTransfEmp
   or f.DataTransfEmp is null)
group by fp.CpfFunc,
         ad.DataAdto

union all

select fp.CpfFunc,
       v.DataVale Data,
       sum(v.ValorBruto) BaseIrrf,
       sum(v.DescontoIR) ValorIRRF
    from FuncContrato f
    join FuncPessoa FP
      on Fp.codigofuncPessoa = F.codigofuncPessoa
    join Vale v
      on V.CodigoEmpresa   = F.CodigoEmpresa
     and V.CodigoFuncContr = F.CodigoFuncContr
    join TipoVale tv
      on tv.CodigoTipoVale  = v.CodigoTipoVale
where f.CodigoEmpresa = :pCodigoEmpresa
  and v.DataVale between :pCompetIni and :pCompetFin
  and tv.PossuiIRRF = 1
  and (v.DataVale >= f.DataTransfEmp
   or f.DataTransfEmp is null)
  and exists(select 1 from ValeParcela VP
        where VP.CodigoEmpresa   = V.CodigoEmpresa
        and VP.CodigoFuncContr = V.CodigoFuncContr
        and VP.DataVale        = V.DataVale
        and VP.Seq             = V.Seq
        and VP.TipoDesconto = 1)   
group by fp.CpfFunc,
    v.DataVale
order by 1, 2

