select fP.CpfFunc,
       TC.TIPOCONTR,
       fpc.DataPgtoFolha DataPgto,
       e.LocalInformeDirf,
       e.DescrRendIsentoOut,
       e.CodigoEstrut,
       3 Origem,
       sum((case when (((ce.ValorEvento * e.FormaInformeDirf) < 0) and (B.VALOREVENTO > 0)) then ((ce.ValorEvento * e.FormaInformeDirf) * -1) else (ce.ValorEvento * e.FormaInformeDirf) end ) - coalesce(B.VALOREVENTO, 0)) Valor,
       e.CodigoEvento,
       e.DescrEvento,
     cast(null as numeric(5,2)) as PercAdicMultaFGTS
 from FuncContrato f
 join FuncPerCalculo fpc
   ON f.CodigoEmpresa = fpc.CodigoEmpresa
  and f.CodigoFuncContr = fpc.CodigoFuncContr
 join CalculoEvento ce
   on fpc.CodigoEmpresa = ce.CodigoEmpresa
  and fpc.CodigoPerCalculo = ce.CodigoPerCalculo
  and fpc.CodigoFuncContr = ce.CodigoFuncContr
 join Evento e
   on ce.CodigoEvento = e.CodigoEvento
 join PeriodoCalculo pc
   on PC.CodigoEmpresa = FPC.CodigoEmpresa
  and PC.CodigoPerCalculo = FPC.CodigoPerCalculo
  and PC.DataFinalFolha >= FPC.DataLocal
 join FuncPessoa FP
  on FP.CodigoFuncPessoa = F.CodigoFuncPessoa
 join TipoContrato TC
   on TC.CODIGOTIPOCONTR = F.CODIGOTIPOCONTR 
  
 LEFT JOIN (SELECT RI.CODIGOEMPRESA,
                   RI.CODIGOFUNCCONTR,
                   RI.COMPET,
                   IE.CODIGOEVENTO,
                   SUM(IE.VALOREVENTO) VALOREVENTO
              FROM RECIBOINTERMITENTE RI
              JOIN INTERMITENTEEVENTO IE
                ON IE.CODIGOEMPRESA = RI.CODIGOEMPRESA
               AND IE.CODIGOFUNCCONTR = RI.CODIGOFUNCCONTR
               AND IE.COMPET = RI.COMPET
               AND IE.CODIGOCONVOCACAO = RI.CODIGOCONVOCACAO
              JOIN EVENTO EV
                ON EV.CODIGOEVENTO = IE.CODIGOEVENTO
               AND EV.CODIGOESTRUT not like '97.09.%'
               AND EV.ORIGEMDADODIRF = 1
               AND EV.LOCALINFORMEDIRF <> 0
               AND EV.FORMAINFORMEDIRF <> 0
              GROUP BY RI.CODIGOEMPRESA,
                       RI.CODIGOFUNCCONTR,
                       RI.COMPET,
                       IE.CODIGOEVENTO) B
    ON B.CODIGOEMPRESA = ce.CodigoEmpresa
   AND B.CODIGOFUNCCONTR = ce.CodigoFuncContr
   AND B.COMPET = {TIMESTAMPADD('DAY', (-{DAYOFMONTH(PC.COMPET)}+1), PC.COMPET)}
   AND B.CODIGOEVENTO = ce.CODIGOEVENTO

where f.CodigoEmpresa = :pCodigoEmpresa
  and fpc.DataPgtoFolha between :pCompetIni and :pCompetFin
  and e.OrigemDadoDirf = 1
  and e.LocalInformeDirf <> 0
  and e.FormaInformeDirf <> 0
  and ce.ValorEvento <> 0
  and not pc.codigotipocalc in (5, 80)
  and e.CodigoEstrut not like '97.09.%'
  and (not exists(Select 1
                                from Rescisao r
                                join RescisaoEvento re
                                on re.CodigoEmpresa = r.CodigoEmpresa
                                and re.CodigoFuncContr = r.CodigoFuncContr
                                and re.Complementar = r.Complementar
                                join Evento ev
                                on ev.CodigoEvento = re.CodigoEvento
                               where r.CodigoFuncContr = f.CodigoFuncContr
                                and r.CodigoEmpresa = f.CodigoEmpresa
								and ce.CodigoEvento  = re.CodigoEvento
                                and ((r.DataResc between PC.DataInicialFolha and PC.DataFinalFolha) or
                                  (r.DataPgtoResc between PC.DataInicialFolha and PC.DataFinalFolha and r.TipoRescisao > 1 and r.CodigoPerCalculo is null) or
                       (r.TipoRescisao > 1 and r.CodigoPerCalculo = pc.CodigoPerCalculo))
                                    and ev.OrigemDadoDirf = 1
                                    and ev.LocalInformeDirf <> 0
                                    and ev.FormaInformeDirf <> 0
                                    and re.ValorEvento <> 0)								
									
      or ((PC.CodigoTipoCalc <> 1) and (PC.CodigoTipoCalc <> 7))
      )
group by fp.CpfFunc,
         TC.TIPOCONTR,
         fpc.DataPgtoFolha,
         e.LocalInformeDirf,
         e.DescrRendIsentoOut,
         e.CodigoEstrut,
         e.CodigoEvento,
         e.DescrEvento
         
UNION ALL

select fP.CpfFunc,
       TC.TIPOCONTR,
       ri.DATAPGTO DataPgto,
       e.LocalInformeDirf,
       e.DescrRendIsentoOut,
       e.CodigoEstrut,
       3 Origem,
       sum(ie.ValorEvento * e.FormaInformeDirf) Valor,
       e.CodigoEvento,
       e.DescrEvento,
     cast(null as numeric(5,2)) as PercAdicMultaFGTS
 from FuncContrato f
 JOIN INTERMITENTEEVENTO ie
   on ie.CODIGOEMPRESA = f.codigoempresa
  and ie.codigofunccontr = f.codigofunccontr 
 join RECIBOINTERMITENTE ri on ri.CODIGOEMPRESA=ie.CODIGOEMPRESA
and ri.CODIGOFUNCCONTR= ie.CODIGOFUNCCONTR
and ri.CODIGOCONVOCACAO=ie.CODIGOCONVOCACAO
and ri.COMPET=ie.COMPET
AND IE.CODIGOCONVOCACAO = RI.CODIGOCONVOCACAO
 join Evento e
   on IE.CodigoEvento = e.CodigoEvento
 join FuncPessoa FP
   on FP.CodigoFuncPessoa = F.CodigoFuncPessoa
 JOIN TIPOCONTRATO TC
   ON TC.CODIGOTIPOCONTR = F.CODIGOTIPOCONTR
where f.CodigoEmpresa = :pCodigoEmpresa
  and RI.DATAPGTO between :pCompetIni and :pCompetFin 
  and e.OrigemDadoDirf = 1
  and e.LocalInformeDirf <> 0
  and e.FormaInformeDirf <> 0
  and IE.ValorEvento <> 0
  and e.CodigoEstrut not like '97.09.%' 
 group by fp.CpfFunc,
          TC.TIPOCONTR,
          RI.DATAPGTO,
          e.LocalInformeDirf,
          e.DescrRendIsentoOut,
          e.CodigoEstrut,
          e.CodigoEvento,
          e.DescrEvento

union all

select fp.CpfFunc,
       TC.TIPOCONTR,
       rf.DataPgto DataPgto,
        e.LocalInformeDirf,
        e.DescrRendIsentoOut,
        e.CodigoEstrut,
        2 Origem,
       sum((case when (((fe.ValorEvento * e.FormaInformeDirf) < 0) and (B.VALOREVENTO > 0)) then ((fe.ValorEvento * e.FormaInformeDirf) * -1) else (fe.ValorEvento * e.FormaInformeDirf) end )  - coalesce(B.VALOREVENTO, 0) ) Valor,
       e.CodigoEvento,
       e.DescrEvento,
	   cast(null as numeric(5,2)) as PercAdicMultaFGTS
 from FuncContrato f
 join ReciboFerias rf
   on f.CodigoEmpresa = rf.CodigoEmpresa
  and f.CodigoFuncContr = rf.CodigoFuncContr
 join FeriasEvento fe
   on rf.CodigoEmpresa = fe.CodigoEmpresa
  and rf.CodigoFuncContr = fe.CodigoFuncContr
  and rf.DataInicial = fe.DataInicial
  and rf.DataInicialFerias= fe.DataInicialFerias 
  and rf.SeqReciboFerias = fe.SeqReciboFerias
 join Evento e
   on fe.CodigoEvento = e.CodigoEvento
  and e.OrigemDadoDirf = 2
  and e.LocalInformeDirf <> 0
  and e.FormaInformeDirf <> 0
  and fe.ValorEvento <> 0 
 join FuncPessoa FP 
   on FP.CodigoFuncPessoa = F.CodigoFuncPessoa 
 join TipoContrato TC
   on TC.CODIGOTIPOCONTR = F.CODIGOTIPOCONTR    
 LEFT JOIN (SELECT RI.CODIGOEMPRESA,
                   RI.CODIGOFUNCCONTR,
                   RI.COMPET,
                   IE.CODIGOEVENTO,
                   SUM(IE.VALOREVENTO) VALOREVENTO
              FROM RECIBOINTERMITENTE RI
              JOIN INTERMITENTEEVENTO IE
                ON IE.CODIGOEMPRESA = RI.CODIGOEMPRESA
               AND IE.CODIGOFUNCCONTR = RI.CODIGOFUNCCONTR
               AND IE.COMPET = RI.COMPET
               AND IE.CODIGOCONVOCACAO = RI.CODIGOCONVOCACAO
              JOIN EVENTO EV
                ON EV.CODIGOEVENTO = IE.CODIGOEVENTO
               AND EV.CODIGOESTRUT not like '97.09.%'
               AND EV.ORIGEMDADODIRF = 1
               AND EV.LOCALINFORMEDIRF <> 0
               AND EV.FORMAINFORMEDIRF <> 0
             GROUP BY RI.CODIGOEMPRESA,
                      RI.CODIGOFUNCCONTR,
                      RI.COMPET,
                      IE.CODIGOEVENTO) B
    ON B.CODIGOEMPRESA = rf.CodigoEmpresa
   AND B.CODIGOFUNCCONTR = rf.CodigoFuncContr
   AND B.COMPET = {TIMESTAMPADD('DAY', (-{DAYOFMONTH(rf.DataPgto)}+1), rf.DataPgto)}
   AND B.CODIGOEVENTO = fe.CODIGOEVENTO    
where f.CodigoEmpresa = :pCodigoEmpresa
  and rf.DataPgto between :pCompetIni and :pCompetFin 
  and rf.TipoRecibo <> 3
  and (rf.DataPgto >= f.DataTransfEmp or f.DataTransfEmp is null)
  and e.CodigoEstrut not like '97.09.%'
group by fp.CpfFunc,
         TC.TIPOCONTR,
         rf.DataPgto,
         e.LocalInformeDirf,
         e.DescrRendIsentoOut,
         e.CodigoEstrut,
         e.CodigoEvento,
         e.DescrEvento

union all

select fp.CpfFunc,
       TC.TIPOCONTR,
       r.DataPgtoResc DataPgto,
       e.LocalInformeDirf,
       e.DescrRendIsentoOut,
       e.CodigoEstrut,
       1 Origem,
       sum((case when (((re.ValorEvento * e.FormaInformeDirf) < 0) and (B.VALOREVENTO > 0)) then ((re.ValorEvento * e.FormaInformeDirf) * -1) else (re.ValorEvento * e.FormaInformeDirf) end ) - coalesce(B.VALOREVENTO, 0) ) Valor,
       e.CodigoEvento,
       e.DescrEvento,
       CASE WHEN R.DATARESC <= CD.DATALIMITEPERCADICMULTAFGTS THEN CD.PERCADICMULTAFGTS ELSE CAST(0 AS NUMERIC(5,2)) END AS PercAdicMultaFGTS 
  from FuncContrato f
  join Rescisao r
    on r.CodigoEmpresa = f.CodigoEmpresa
   and r.CodigoFuncContr = f.CodigoFuncContr
  Join RescisaoEvento re
    on re.CodigoEmpresa = r.CodigoEmpresa
   and re.CodigoFuncContr = r.CodigoFuncContr
   and re.Complementar = r.Complementar
 join Evento e
   on e.CodigoEvento = re.CodigoEvento
 join FuncPessoa FP
  on FP.codigoFuncPessoa  = F.CodigoFuncPessoa
 join CausaDemissao CD
   on CD.CodigoCausa = R.CodigoCausa
 join TipoContrato TC
   on TC.CODIGOTIPOCONTR = F.CODIGOTIPOCONTR    
 LEFT JOIN (SELECT RI.CODIGOEMPRESA,
                   RI.CODIGOFUNCCONTR,
                   RI.COMPET,
                   IE.CODIGOEVENTO,
                   SUM(IE.VALOREVENTO) VALOREVENTO
              FROM RECIBOINTERMITENTE RI
              JOIN INTERMITENTEEVENTO IE
                ON IE.CODIGOEMPRESA = RI.CODIGOEMPRESA
               AND IE.CODIGOFUNCCONTR = RI.CODIGOFUNCCONTR
               AND IE.COMPET = RI.COMPET
               AND IE.CODIGOCONVOCACAO = RI.CODIGOCONVOCACAO
              JOIN EVENTO EV
                ON EV.CODIGOEVENTO = IE.CODIGOEVENTO
               AND EV.CODIGOESTRUT not like '97.09.%'
               AND EV.ORIGEMDADODIRF = 1
               AND EV.LOCALINFORMEDIRF <> 0
               AND EV.FORMAINFORMEDIRF <> 0
             GROUP BY RI.CODIGOEMPRESA,
                      RI.CODIGOFUNCCONTR,
                      RI.COMPET,
                      IE.CODIGOEVENTO) B
    ON B.CODIGOEMPRESA = re.CodigoEmpresa
   AND B.CODIGOFUNCCONTR = re.CodigoFuncContr
   AND B.COMPET = {TIMESTAMPADD('DAY', (-{DAYOFMONTH(r.DATARESC)}+1), r.DATARESC)}
   AND B.CODIGOEVENTO = re.CODIGOEVENTO   
   
where  f.CodigoEmpresa = :pCodigoEmpresa
  and r.DataPgtoResc between :pCompetIni and :pCompetFin 
  and e.OrigemDadoDirf = 1
  and e.LocalInformeDirf <> 0
  and e.FormaInformeDirf <> 0
  and re.ValorEvento <> 0
  and e.CodigoEstrut not like '97.09.%'
  
group by fp.CpfFunc,
         TC.TIPOCONTR,
         r.DataPgtoResc,
         e.LocalInformeDirf,
         e.DescrRendIsentoOut,
         e.CodigoEstrut,
         e.CodigoEvento,
         e.DescrEvento,
         CASE WHEN R.DATARESC <= CD.DATALIMITEPERCADICMULTAFGTS THEN CD.PERCADICMULTAFGTS ELSE CAST(0 AS NUMERIC(5,2)) END 
order by 1, 2, 5, 3, 4