  select f.codigoempresa,
         f.CodigoFuncContr,
         ed.data data,
         ed.codigohorario horario,
         h.tipohorario tipo,
         MIN(hd.horaentrada) MinHEntra,
         MIN(hd.horasaida) MinHSai,
         MAX(hd.horaentrada) MaxHEntra,
         MAX(hd.horasaida) MaxHSai
   FROM  FuncContrato F
         Inner JOIN FuncEscala FE
                      ON F.CodigoEmpresa = FE.CodigoEmpresa
                     and F.CodigoFuncContr = FE.CodigoFuncContr
         LEFT OUTER JOIN EscalaDetalhe ED
                      ON FE.CodigoEscala = ED.CodigoEscala
         LEFT OUTER JOIN Horario H
                      ON ED.CodigoHorario = H.CodigoHorario
         LEFT OUTER JOIN HorarioDetalhe HD
                      ON H.CodigoHorario = HD.CodigoHorario
   where f.codigoempresa = :codigoempresa
     and f.CodigoFuncContr = :CodigoFuncContr
group by f.codigoempresa,
         f.CodigoFuncContr,
         ed.data,
         ed.codigohorario,
         h.tipohorario
order by f.codigoempresa,
         f.CodigoFuncContr
