  select FM.CodigoEmpresa,
         FM.CodigoFuncContr,
         E.CodigoEstrut,
         FM.CodigoEvento,
         RF.SeqReciboFerias,
         FM.DataInicialFerias,
		 RF.DataInicial,
         FM.ValorEvento,
         FM.ReferEvento,
         RF.DiasFerias,
         RF.DiasAbono,
         RF.DataFinalFerias,
         RF.DataAbono,
         FM.CodigoProfTipoAula, 
         TA.DescrProfTipoAula,
         Coalesce(FM.CodigoBenef, 0) CodigoBenef
    from ReciboFerias RF
    join FeriasMovim FM
      on RF.CodigoEmpresa      = FM.CodigoEmpresa
     and RF.CodigoFuncContr    = FM.CodigoFuncContr
     and RF.DataInicial        = FM.DataInicial
     and RF.DataInicialFerias  = FM.DataInicialFerias
     and RF.SeqReciboFerias = FM.SeqReciboFerias
    join Evento E
      on FM.CodigoEvento       = E.CodigoEvento
    left join ProfTipoAula TA 
      on TA.CodigoEmpresa      = FM.CodigoEmpresa 
     and TA.CodigoProfTipoAula = FM.CodigoProfTipoAula 
   where RF.CodigoEmpresa      = :CodigoEmpresa
     and RF.CodigoFuncContr    = :CodigoFuncContr
     and (((RF.DataInicialFerias between :DataInicialFerias and :DataFinalFerias
      or RF.DataFinalFerias    between :DataInicialFerias and :DataFinalFerias)
     and RF.SeqReciboFerias = 1) 
     or  (RF.SeqReciboFerias > 1 
     and coalesce(RF.PERCENTUALRECIBOFERIAS, 0) <= 0 
     and RF.DataPgto between :DataInicialFerias and :DataFinalFerias ))
	 
order by 1, 2, 3, 4, 5, 6
