  select A.CodigoEmpresa,
         A.CodigoFuncContr,
         B.CodigoEstrut,
         A.CodigoEvento,
         RF.SeqReciboFerias,
         A.DataInicialFerias,
		 RF.DataInicial,  
         A.ValorEvento,
         A.ReferEvento,
         RF.DiasFerias,
         RF.DiasAbono,
         RF.DataFinalFerias,
         RF.DataAbono,
         A.CodigoProfTipoAula, 
         TA.DescrProfTipoAula,
         Coalesce(A.CodigoBenef, 0) CodigoBenef
    from ReciboFerias RF 
    join FeriasMovim A
      on RF.CodigoEmpresa     = A.CodigoEmpresa
     and RF.CodigoFuncContr   = A.CodigoFuncContr
     and RF.DataInicial       = A.DataInicial
     and RF.DataInicialFerias = A.DataInicialFerias
     and RF.SeqReciboFerias   = A.SeqReciboFerias
    join Evento B
      on B.CodigoEvento = A.CodigoEvento
    left join ProfTipoAula TA 
      on TA.CodigoEmpresa = A.CodigoEmpresa 
     and TA.CodigoProfTipoAula = A.CodigoProfTipoAula 
   where A.CodigoEmpresa      = :CodigoEmpresa
     and A.CodigoFuncContr    = :CodigoFuncContr
     and A.DataInicialFerias  = :DataInicialFerias 
     and RF.SeqReciboFerias   = :SeqReciboFerias 
     and ((RF.PAGAUMTERCO = '0' 
     and not B.CODIGOESTRUT in('03.01.50.01', '03.02.50.01'))
      or RF.PAGAUMTERCO = '1')
order by 1, 2, 3, 4, 5, 6
