merge into FuncPerCalculo D
using (
  select cast(:CodigoEmpresaDest as Integer) CodigoEmpresa,
         cast(:CodigoFuncContrDest as Integer) CodigoFuncContr,
         p.CodigoPerCalculo,
         fpc.DataCargo,
         fpc.DataEscala,
         cast(:DataLocal as Date) DataLocal,
         fpc.DataSalario,
         cast(:DataPgtoFolha as Date) DataPgtoFolha,
         fpc.SeqCalculo,
         p.CodigoEmpresa CodigoEmpresaImp , 
         p.CodigoPerCalculo CodigoPerCalcImp, 
         fpc.OrigemDado,
         cast(0 as Integer) as EmiteEnvel,
         fpc.DataHoraLcto,
         fpc.CodigoUsuario,
         fpc.CodigoSind,
         fpc.DataFuncSindicato,
         fpc.DataSindconvencao,
         fpc.DataSindcontrib1,
         fpc.DataSindcontrib2,
         fpc.DataSindcontrib3,
         fpc.DataSindcontrib4,
         fpc.DataSindcontrib5,
         fpc.DataSindcontrib6,
	     fpc.DataEscalaValeTransp,
	     fpc.GerarEsocial,
		 fpc.SeqFuncSalario
    from FuncPerCalculo fpc,
         PeriodoCalculo pc,
         PeriodoCalculo p
   where fpc.CodigoEmpresa = :CodigoEmpresaOrig
     and fpc.CodigoFuncContr = :CodigoFuncContrOrig
     and pc.CodigoEmpresa = fpc.CodigoEmpresa
     and pc.CodigoPerCalculo = fpc.CodigoPerCalculo
     and p.CodigoEmpresa = :CodigoEmpresaDest
     and p.CodigoTipoCalc = :CodigoTipoCalc
     and p.Compet = pc.Compet
     and pc.CodigoTipoCalc  = 1) O
on (O.CodigoEmpresa = D.CodigoEmpresa
and O.CodigoFuncContr = D.CodigoFuncContr
and O.CodigoPerCalculo = D.CodigoPerCalculo)
 
WHEN NOT MATCHED THEN 
insert(CodigoEmpresa, 
       CodigoFuncContr, 
       CodigoPerCalculo, 
       DataCargo, 
	   DataEscala,
       DataLocal, 
       DataSalario, 
       DataPgtoFolha, 
       SeqCalculo,
       CodigoEmpresaImp, 
       CodigoPerCalcImp, 
       OrigemDado,
       EmiteEnvel, 
       DataHoraLcto, 
       CodigoUsuario, 
       CodigoSind, 
       DataFuncSindicato, 
       DataSindconvencao, 
       DataSindcontrib1, 
       DataSindcontrib2, 
       DataSindcontrib3, 
       DataSindcontrib4, 
       DataSindcontrib5,   
       DataSindcontrib6, 
       DataEscalaValeTransp,
	   GerarEsocial,
	   SeqFuncSalario)
values
    (O.CodigoEmpresa, 
    O.CodigoFuncContr, 
    O.CodigoPerCalculo, 
    O.DataCargo, 
    O.DataEscala,
    O.DataLocal, 
    O.DataSalario, 
    O.DataPgtoFolha, 
    O.SeqCalculo,
    O.CodigoEmpresaImp, 
    O.CodigoPerCalcImp, 
    O.OrigemDado,
    O.EmiteEnvel, 
    O.DataHoraLcto, 
    O.CodigoUsuario, 
    O.CodigoSind, 
    O.DataFuncSindicato, 
    O.DataSindconvencao, 
    O.DataSindcontrib1, 
    O.DataSindcontrib2, 
    O.DataSindcontrib3, 
    O.DataSindcontrib4, 
    O.DataSindcontrib5, 
    O.DataSindcontrib6, 
    O.DataEscalaValeTransp,
	O.GerarEsocial,
	O.SeqFuncSalario)