select fpc.CodigoFuncContr,
       fp.NomeFunc,
       flc.CodigoLocalCtb,
       flc.LocalCtbRateio,
       tc.TipoContr,
       cfg.CodigoEstabCtb,
       cfg.CodigoTabGPS
  from FuncPerCalculo fpc
  join FuncLocal fl
    on fpc.CodigoEmpresa = fl.CodigoEmpresa
   and fpc.CodigoFuncContr = fl.CodigoFuncContr
   and fpc.DataLocal = fl.DataTransf
  join FuncContrato f
    on fpc.CodigoEmpresa = f.CodigoEmpresa
   and fpc.CodigoFuncContr = f.CodigoFuncContr
  join CfgEstabFpa cfg
    on fl.CodigoEmpresa = cfg.CodigoEmpresa
   and fl.CodigoEstab = cfg.CodigoEstab    
  join TipoContrato tc
    on Tc.CodigoTipoContr = F.CodigoTipoContr
  join PeriodoCalculo pc
    on PC.CodigoEmpresa = FPC.CodigoEmpresa
   and PC.CodigoPerCalculo = FPC.CodigoPerCalculo
  join FuncPessoa FP
    on FP.CodigoFuncPessoa = F.CodigoFuncPessoa 
  join  FuncLocalCTB flc
    on flc.CodigoEmpresa = fpc.CodigoEmpresa
   and flc.CodigoFuncContr = fpc.CodigoFuncContr 
   and flc.DataOpcao = (Select max(DataOpcao) 
                          from FuncLocalCTB flcs
       where flcs.CodigoEmpresa   = flc.CodigoEmpresa
                           and flcs.CodigoFuncContr = flc.CodigoFuncContr
                           and flcs.DataOpcao <= PC.DataFinalFolha) 
 where fpc.CodigoEmpresa = :pCodigoEmpresa
   and fpc.CodigoPerCalculo = :pCodigoPerCalculo
   and PC.DataFinalFolha >= FPC.DataLocal
order by 6, 1
