  select FS.CodigoEmpresa,
         FS.CodigoFuncContr,
         FS.TipoSalario,
         FS.ValorSal,
         FS.ComplSal,
         FS.AntecSal,
         FS.CodigoMotivo,
         FS.SalCarne
    from FuncSalario FS
   where FS.CodigoEmpresa = :CodigoEmpresa
     and FS.CodigoFuncContr    = :CodigoFuncContr
     and FS.DataInicial   = (select max(FuS.DataInicial)
                               from FuncSalario FuS
                              where FuS.DataInicial   <= :DataFinal
                                and FuS.CodigoEmpresa = FS.CodigoEmpresa
                                and FuS.CodigoFuncContr    = FS.CodigoFuncContr)
     and FS.SEQ   = (select max(FuS.SEQ)
                      from FuncSalario FuS
                     where FuS.DataInicial   = FS.DataInicial
                       and FuS.CodigoEmpresa = FS.CodigoEmpresa 
					   and FuS.CodigoFuncContr = FS.CodigoFuncContr)
order by 1, 2
