Select FS.CodigoEmpresa,
       FS.CodigoFuncContr,
       FS.DataInicial,
       FL.CodigoEstab,
       FL.DataTransf,
       FS.ValorSal,
       FS.TipoSalario,
       FS.CodigoEstrutSal,
       FS.CodigoTabSal,
       FS.CodigoMotivo,
       M.DescrMotivo,
       FS.ComplSal,
       FS.AntecSal,
       cast('F' as varchar(1)) as Tipo
  from FuncSalario FS
  join FuncLocal FL
    on FL.CodigoEmpresa = FS.CodigoEmpresa
   and FL.CodigoFuncContr = FS.CodigoFuncContr
   and FL.DataTransf = (Select Max(FLa.DataTransf)
                          from FuncLocal FLa
                         where FLa.CodigoEmpresa = FL.CodigoEmpresa
                           and FLa.CodigoFuncContr = FL.CodigoFuncContr
                           and FLa.DataTransf <= FS.DataInicial)
   and FS.SEQ = (select max(FuA.SEQ)
                 from FuncSalario FuA
                 where FuA.DataInicial   = FS.DataInicial
                 and FuA.CodigoEmpresa = FS.CodigoEmpresa 
                 and FuA.CodigoFuncContr = FS.CodigoFuncContr)
  join Motivo M
    on M.CodigoMotivo = FS.CodigoMotivo
 where FS.CodigoEmpresa = :pCodigoEmpresa
   and FS.CodigoFuncContr = :pCodigoFuncContr
   and FL.CodigoEstab = :pCodigoEstab

union 

Select FL.CodigoEmpresa,
       FL.CodigoFuncContr,
       FS.DataInicial,
       FL.CodigoEstab,
       Fl.DataTransf ,
       FS.ValorSal,
       FS.TipoSalario,
       FS.CodigoEstrutSal,
       FS.CodigoTabSal,
       FS.CodigoMotivo,
       M.DescrMotivo,
       FS.ComplSal,
       FS.AntecSal,
       cast('V' as varchar(1)) as Tipo
  from FuncLocal FL
  join FuncSalario FS
    on FS.Codigoempresa = FL.CodigoEmpresa
   and FS.CodigoFuncContr = FL.CodigoFuncContr
   and FS.DataInicial = (Select max(FSa.DataInicial)
                          from FuncSalario FSa
                         where FSa.CodigoEmpresa = FS.CodigoEmpresa
                           and FSa.CodigoFuncContr = FS.CodigoFuncContr
                           and FSa.DataInicial <= FL.DataTransf)
   and FS.SEQ = (select max(FuB.SEQ)
                 from FuncSalario FuB
                 where FuB.DataInicial   = FS.DataInicial
                 and FuB.CodigoEmpresa = FS.CodigoEmpresa 
                 and FuB.CodigoFuncContr = FS.CodigoFuncContr)
  join Motivo M
    on M.CodigoMotivo = FS.CodigoMotivo
 where FL.CodigoEmpresa = :pCodigoEmpresa
   and FL.CodigoFuncContr = :pCodigoFuncContr
   and FL.CodigoEstab = :pCodigoEstab

order by 1, 2, 3, 4
